*
* Replication file for King, Plosser, Stock and Watson,
* "Stochastic Trends and Economic Fluctuations", AER 1991,
* vol 81, pp 819-840.
*
* Generation of figures 5 and 6 - comparison with Solow Residuals
* The start of this is the same as kpsw5.prg - estimating the VECM
* for the baseline six variable model
*
open data kpswdata.rat
calendar 1947 1 4
all 1988:04
data(format=rats) / c in y mp dp r
*
set igapy = in-y
set cgapy = c-y
set r     = r/400.0
set realr = r-dp
*
* Re-estimate the equations from table 2
*
@swdols(lags=5,ar=4) 1954:1 *
# mp y r
compute betay=%beta(1),betar=%beta(2)
*
@swdols(lags=5,ar=4) 1954:1 *
# cgapy realr
compute phi1=%beta(1)
*
@swdols(lags=5,ar=4) 1954:1 *
# igapy realr
compute phi2=%beta(1)
*
* Define the error correction equations
*
equation(coeffs=||-betay,0.0,0.0,1.0,-betar,0.0||) mdemand
# y c in mp r dp
equation(coeffs=||-1.0,1.0,0.0,0.0,-phi1,phi1||) cratio
# y c in mp r dp
equation(coeffs=||-1.0,0.0,1.0,0.0,-phi2,phi2||) iratio
# y c in mp r dp
*
* Define the atilde matrix
* This uses a different sign convention on betar than shown in the paper
*
compute atilde=$
||1.0  ,0.0  ,0.0|$
  1.0  ,0.0  ,phi1|$
  1.0  ,0.0  ,phi2|$
  betay,betar,betar|$
  0.0  ,1.0  ,1.0|$
  0.0  ,1.0  ,0.0||
*
* Estimate the cointegrated VAR
*
system(model=varmodel)
variables y c in mp r dp
lags 1 to 9
det constant
ect mdemand cratio iratio
end(system)
*
estimate(noprint,resids=uresids) 1954:1 *
*
* Get the long run response matrix
*
impulse(model=varmodel,decomp=%identity(6),results=baseimp,steps=200,noprint)
compute lrsum=%xt(baseimp,200)
*
* Compute a factor
*
compute d=%ginv(atilde)*lrsum
@forcedfactor(force=rows) %sigma d f
*
* Transform to the balanced growth shock
*
compute bgrowthw=%xrow(inv(f),1)
set bgrowth 1954:1 * = %dot(bgrowthw,%xt(uresids,t))
*
* Compute the mean growth rate and add it to the balanced growth shock
*
sstats 1954:2 1988:4 y-y{1}>>dym
set bgrowth 1954:1 * = bgrowth+dym
graph
# bgrowth
*
* We're going to want this converted to annual sums (as the other Solow residuals are
* in annual form). The easiest way to do this is to allow the DATA instruction to do the
* work. So we copy this out and read it back in the annual calendar scheme.
*
open copy bgrowth.rat
copy(format=rats) 1954:1 * bgrowth
close copy
*
* Switch calendars and read in the data with the Solow residual estimates
*
cal 1947
clear
open data kpswdata.rat
data(format=rats) / hall ypotden prescott denison bcturnpt
open data bgrowth.rat
data(format=rats,compact=sum) / bgrowth
*
spgraph(vfields=2,header='Figure 5 Balanced Growth Shock with (A) Hall, (B) Prescott',ylabels=||'A','B'||)
graph 2
# bgrowth 1951:1 1988:4
# hall
graph 2
# bgrowth 1951:1 1988:4
# prescott
spgraph(done)
cross hall bgrowth 1954:1 1979:1 -1 1
cross prescott bgrowth 1954:1 1979:1 -1 1
print / bgrowth
*
* Get the cumulated values of the balanced growth shock and adjust its level to match with
* the Denison estimate in 1954.
*
acc bgrowth / bgrowtha
set bgrowtha = bgrowtha*.01
compute fiddle = denison(1954:1)-bgrowtha(1954:1)
set bgrowtha = bgrowtha+fiddle
*
graph(header='Figure 6. Estimates of Annual Trend Output',subheader='Denison and the Permanent Component') 2
# denison
# bgrowtha

