*
* Replication file for King, Plosser, Stock and Watson,
* "Stochastic Trends and Economic Fluctuations", AER 1991,
* vol 81, pp 819-840.
*
* This file includes analysis for table 5
*
open data kpswdata.rat
calendar 1947 1 4
all 1988:04
data(format=rats) / c in y mp dp r
*
set igapy = in-y
set cgapy = c-y
set r     = r/400.0
set realr = r-dp
*
* Re-estimate the equations from table 2
*
@swdols(lags=5,ar=4) 1954:1 *
# mp y r
compute betay=%beta(1),betar=%beta(2)
*
@swdols(lags=5,ar=4) 1954:1 *
# cgapy realr
compute phi1=%beta(1)
*
@swdols(lags=5,ar=4) 1954:1 *
# igapy realr
compute phi2=%beta(1)
*
* Define the error correction equations
*
equation(coeffs=||-betay,0.0,0.0,1.0,-betar,0.0||) mdemand
# y c in mp r dp
equation(coeffs=||-1.0,1.0,0.0,0.0,-phi1,phi1||) cratio
# y c in mp r dp
equation(coeffs=||-1.0,0.0,1.0,0.0,-phi2,phi2||) iratio
# y c in mp r dp
*
* Define the atilde matrix
* This uses a different sign convention on betar than shown in the paper
*
compute atilde=$
||1.0  ,0.0  ,0.0|$
  1.0  ,0.0  ,phi1|$
  1.0  ,0.0  ,phi2|$
  betay,betar,betar|$
  0.0  ,1.0  ,1.0|$
  0.0  ,1.0  ,0.0||
*
* Estimate the cointegrated VAR
*
system(model=varmodel)
variables y c in mp r dp
lags 1 to 9
det constant
ect mdemand cratio iratio
end(system)
*
estimate(noprint) 1954:1 *
*
* Get the long run response matrix
*
impulse(model=varmodel,decomp=%identity(6),results=baseimp,steps=200,noprint)
compute lrsum=%xt(baseimp,200)
*
* Compute a factor
*
compute d=%ginv(atilde)*lrsum
@forcedfactor(force=rows) %sigma d f
*
* Compute and graph the responses of the output, consumption and investment to
* the three long-run shocks (figure 4).
*
impulse(model=varmodel,decomp=f,results=imps,steps=28,noprint)
table(noprint) 1 28 imps(1,1) to imps(3,1) imps(1,2) to imps(3,2) imps(1,3) to imps(3,3)
spgraph(vfields=3,hfields=3,xlabels=||'Log Output','Log Consumption','Log Investment'||,$
                            ylabels=||'Balanced Growth','Inflation','Real Interest Rate'||)
do i=1,3
  do j=1,3
     graph(max=%maximum,min=%minimum,number=0)
     # imps(i,j) 1 28
  end do j
end do i
spgraph(done)
*
* Error decomposition (table 5)
*
errors(decomp=f,model=varmodel,steps=48,labels=||'BalGrowth','Inflation','Real Rate','Misc1','Misc2','Misc3'||)
*
* Historical decomposition (figure 3). Because this uses fixed horizons rather the
* fixed forecast start period used by the standard HISTORY instruction, it needs to
* be done by a sequence of HISTORY instructions, where a single time period is extracted
* each period.
*
dec vect[series] e12(3)
dec rect[series] h12(3,3)
do time=1957:1,1988:4
   history(decomp=f,model=varmodel,results=hdecomp) * 12 time-11
   set e12(1) time time = y-hdecomp(1,1)
   set e12(2) time time = c-hdecomp(1,2)
   set e12(3) time time = in-hdecomp(1,3)
   do i=1,3
      do j=1,3
         set h12(i,j) time time = hdecomp(i+1,j)
      end do j
   end do i
end do time
spgraph(vfields=3,hfields=3,$
   header='Figure 3. Historical Forecast Error Decomposition',subheader='Six Variable Model',$
   xlabels=||'Log Output','Log Consumption','Log Investment'||,$
   ylabels=||'Balanced Growth','Inflation','Real Interest Rate'||)
do i=1,3
   do j=1,3
      graph 2 i j
      # e12(j)
      # h12(i,j)
   end do j
end do i
spgraph(done)

