*
* Replication file for King, Plosser, Stock and Watson,
* "Stochastic Trends and Economic Fluctuations", AER 1991,
* vol 81, pp 819-840.
*
* This file includes analysis for table 4
*
compute ndraws=500
compute nvar  =3
compute nstep =25
*
open data kpswdata.rat
calendar 1947 1 4
all 1988:04
data(format=rats) / c in y mp dp r
*
equation(coeffs=||1.0,-1.0||) covery
# c y
equation(coeffs=||1.0,-1.0||) iovery
# in y
*
system(model=varmodel)
variables y c in
lags 1 to 9
det constant
ect covery iovery
end(system)
*
estimate
*
impulse(model=varmodel,decomp=%identity(3),results=baseimp,noprint) * 500
compute lrsum=%xt(baseimp,500)
compute atilde=||1.0|1.0|1.0||
*
compute k=%cols(atilde)
compute d=inv(%innerxx(atilde))*tr(atilde)*lrsum
*
source forcedfactor.src
@forcedfactor(force=row) %sigma d f
*
declare rect sxx svt swish betaols betadraw ranc
declare symm sigmad

compute sxx    =%decomp(%xx)
compute svt    =%decomp(inv(%nobs*%sigma))
compute betaols=%modelgetcoeffs(varmodel)
compute ncoef  =%rows(sxx)
compute wishdof=%nobs-ncoef
dim ranc(ncoef,nvar)
*
* Bookkeeping series for the IRF for the balanced growth
* shock and the error decomposition percentages
*
dec rect[series] responses(nstep,nvar)
dec rect[series] errors(nstep,nvar)
do i=1,nstep
   do j=1,nvar
      set responses(i,j) 1 ndraws = 0.0
      set errors(i,j) 1 ndraws    = 0.0
   end do j
end do i
*
infobox(action=define,progress,lower=1,upper=ndraws) 'Monte Carlo Integration'
do draws = 1,ndraws
   if %clock(draws,2)==1 {
      compute sigmad  =%ranwisharti(svt,wishdof)
      compute swish   =%decomp(sigmad)
      compute ranc    =%ran(1.0)
      compute betau   =sxx*ranc*tr(swish)
      compute betadraw=betaols+betau
   }
   else
      compute betadraw=betaols-betau

   compute %modelsetcoeffs(varmodel,betadraw)
   *
   *
   impulse(model=varmodel,decomp=%identity(3),results=baseimp,noprint) * 500
   compute lrsum=%xt(baseimp,500)
   *
   compute d=inv(%innerxx(atilde))*tr(atilde)*lrsum
   @forcedfactor(force=row) %sigma d f
   compute lrfactor=lrsum*f
   impulse(noprint,model=varmodel,decomp=f/lrfactor(1,1),results=impulses) * 25
   *
   *  Store the impulse responses. In this case, we're only interested in the
   *  responses to the first shock.
   *
   do i=1,nstep
      do j=1,nvar
         set responses(i,j) draws draws = impulses(j,1)(i)
      end do i
   end do i
   *
   *  Store the decomposition of variance. Again, we're only interested in the
   *  fraction explained by the first shock.
   *
   errors(noprint,model=varmodel,decomp=f,results=decvar) * 25
   do i=1,nstep
      do j=1,nvar
         set errors(i,j) draws draws = decvar(j,1)(i)
      end do j
   end do i
   infobox(current=draws)
end do draws
infobox(action=remove)
*
report(action=define)
*report(atrow=1,atcol=2,tocol=4,align=center) 'Fraction of the forecast-error variance'
*report(atrow=2,atcol=2,tocol=4,align=center) 'attributed to the real permanent shock'
report(atrow=3,atcol=1,align=center) 'Horizon' 'y' 'c' 'i'
compute row=1
dofor horizon = 1 4 8 12 16 20 24
   compute row=row+3
   report(atrow=row,atcol=1) horizon
   do j=1,nvar
      stats(noprint) errors(horizon,j) 1 ndraws
      report(atrow=row,atcol=j+1) %mean
      report(atrow=row+1,atcol=j+1,special=parens) sqrt(%variance)
   end do j
end do horizon
report(action=format,picture='*.##',atrow=4,align=decimal)
report(action=show,window='This is the forest')
*
*
dec vect[series] mid(nvar) upper(nvar) lower(nvar)
do j=1,nvar
   do i=1,nstep
      sstats(mean) 1 ndraws responses(i,j)>>first responses(i,j)**2>>second
      compute stddev=sqrt(second-first**2)
      set mid(j)   i i = first
      set upper(j) i i = first+stddev
      set lower(j) i i = first-stddev
   end do i
end do j
*
table(noprint) 1 nstep upper lower
*
spgraph(vfields=nvar,header='Figure 2 - Responses to Shock in Real Permanent Component')
do j=1,nvar
   graph(max=%maximum,min=%minimum,nodates) 3
   # mid(j)
   # upper(j) / 2
   # lower(j) / 2
end do j
spgraph(done)


