*
* Replication file for King, Plosser, Stock and Watson,
* "Stochastic Trends and Economic Fluctuations", AER 1991,
* vol 81, pp 819-840.
*
* This file includes analysis for table 3
*
open data kpswdata.rat
calendar 1947 1 4
all 1988:04
data(format=rats) / c in y mp dp r
*
set dp = dp*400.0
@swtrends(lags=6,det=trend,null=3) 1954:1 *
# c in mp y r dp
@johmle(lags=6,det=trend) 1954:1 *
# c in mp y r dp
@swdols(rank=3,lags=5,ar=4) 1954:1 *
# c in mp y r dp
test(title='Hypothesis 1')
# 1 2 3 4 5 6 9
# 1.0 0.0 0.0 1.0 0.0 0.0 0.0
*
* The second hypothesis requires an estimation with rank=4, and
* because R appears with a free coefficient in the third restriction,
* this is most easily done by rearranging the variables to put the
* normalizations on c, i, mp and dp
*
@swdols(rank=4,lags=5,ar=4) 1954:1 *
# c in mp dp y r
test(title='Hypothesis 2')
# 1 2 3 4 7 8
# 1.0 0.0 1.0 0.0 0.0 1.0
*
* The final two restrictions return to the original specification
*
@swdols(rank=3,lags=5,ar=4) 1954:1 *
# c in mp y r dp
restrict(title='Hypothesis 3') 5
# 1
# 1.0 1.0
# 2 3
# 1.0 -1.0 0.0
# 4
# 1.0 1.0
# 5 6
# 1.0 -1.0 0.0
# 9
# 1.0 0.0
*
restrict(title='Hypothesis 4') 7
# 1
# 1.0 1.0
# 2 3
# 1.0 -1.0 0.0
# 4
# 1.0 1.0
# 5 6
# 1.0 -1.0 0.0
# 7
# 1.0 1.0
# 8
# 1.0 0.0
# 9
# 1.0 0.0

