*
* Replication file for King, Plosser, Stock and Watson,
* "Stochastic Trends and Economic Fluctuations", AER 1991,
* vol 81, pp 819-840.
*
* This file includes analysis through table 1
*
open data kpswdata.rat
calendar 1947 1 4
all 1988:04
data(format=rats) / c in y mp dp r
*
* The data in figure 1a have their levels adjusted to their first
* values are .20,.40,.60 and .80 respectively.
*
set dmp = mp-mp(1947:1)+.20
set din = in-in(1947:1)+.40
set dc  = c -c(1947:1)+.60
set dy  = y -y(1947:1)+.80
graph(header='Figure 1a. Logarithms of Data',key=attached,klabels=||'m-p','i','c','y'||) 4
# dmp
# din
# dc
# dy
*
set igapy = in-y
set cgapy = c-y
*
set digapy = igapy-igapy(1988:4)+.20
set dcgapy = cgapy-cgapy(1988:4)+.40
sstats(mean) / digapy>>iymean dcgapy>>cymean
graph(header='Figure 1b. Logarithms of the great ratios',key=attached,klabels=||'i-y','c-y'||,vgrid=||iymean,cymean||) 2
# digapy
# dcgapy
*
* Unit root tests on the basic variables
*
@dfunit(lags=5,trend) y  1947:3 *
@dfunit(lags=5,trend) c  1947:3 *
@dfunit(lags=5,trend) in 1947:3 *
@dfunit(lags=5,trend) mp 1952:3 *
@dfunit(lags=5,trend) dp 1952:3 *
@dfunit(lags=5,trend) r  1952:3 *
*
* And on the first difference of real money and the
* real rate
*
set dmp = mp-mp{1}
@dfunit(lags=5,trend) dmp 1952:3 *
set rdp = r-400.0*dp
@dfunit(lags=5) rdp 1952:3 *
*
* Unit root tests on the great ratios
*
@dfunit(lags=5,trend) cgapy 1947:3 *
@dfunit(lags=5,trend) igapy 1947:3 *
*
* Generate Table 1A
* Note that the log likelihoods in the article don't include
* the integrating constants.
*
source modelcompanion.src
@varcalc(lags=6,model=v3) 1949:1 *
# y c in
eigen(cvalues=cvnot) %modelcompanion(v3)
compute loglnot=%logl
@varcalc(lags=6,model=v3,det=trend) 1949:1 *
# y c in
eigen(cvalues=cvt) %modelcompanion(v3)
compute loglt=%logl
report(action=define)
report(row=new,atcol=1,span) 'VAR(6) with constant'
report(row=current,atcol=4,span) 'VAR(6) with constant and trend'
report(row=new,atcol=1) 'Real' 'Imaginary' 'Modulus' 'Real' 'Imaginary' 'Modulus'
do i=1,6
   report(row=new,atcol=1) %real(cvnot(i)) %imag(cvnot(i)) %cabs(cvnot(i)) %real(cvt(i)) %imag(cvt(i)) %cabs(cvt(i))
end do i
report(row=new,atcol=1) 'Log L'
report(row=current,atcol=2) loglnot
report(row=current,atcol=5) loglt
report(action=format,picture='*.##')
report(action=show)
*
* Generate Table 1B
*
@swtrends(lags=6,det=trend,null=3) 1949:1 *
# y c in
@johmle(lags=6,det=trend) 1949:1 *
# y c in
*
* Generate Table 1C
*
@swdols(rank=2,lags=5) 1949:1 *
# c in y
test(title='test of balanced growth')
# 1 2
# 1.0 1.0


