*
*  Replication of the interest rates example in Gonzalo, J., and C.W.J. Granger (1995)
*  "Estimation of common long memory components in cointegrated systems",
*  Journal of Business & Economic Statistics 13:1, 27-36.
*
open data ggdata.rat
calendar 1969 1 12
data(format=rats) 1969:1 1988:12 canst canmt canlt usast usamt usalt
*
graph(header='Figure 1 Canada Interest Rates',key=upleft) 3
# canst
# canmt
# canlt
graph(header='Figure 2 US Interest Rates',key=upleft) 3
# usast
# usamt
# usalt
*
* Do table of ADF tests
* The values in the table are computed with a common estimation
* range, so the @dfunit start entry is adjusted to produce the
* same results
*
source dfunit.src
report(action=define)
report(atcol=2) 'ADF(0)' 'ADF(1)' 'ADF(2)' 'ADF(3)' 'ADF(4)'
dofor s = canst canmt canlt usast usamt usalt
   report(row=new,atcol=1) %L(s)
   do lags=0,4
      @dfunit(lags=lags,noprint) s 1969:5-lags *
      report(row=current,atcol=lags+2) %cdstat
   end do lags
end dofor s
report(action=format,picture='*.##')
report(action=show)
*
* Do Johansen LR tests for cointegrating rank
* While the paper indicates lags=3, that is the number in the full VAR, which would be the same as
* lags=2 here (where this counts the number of lagged differences). The eigenvalues match exactly
* (other than slight rounding differences). The test statistics differ only by a different choice
* for "T" (the number of observations).
*
@johmle(lags=2,vectors=ecanada,dual=dcanada,eigenval=vcanada)
# canst canmt canlt
@johmle(lags=2,vectors=eusa,dual=dusa,eigenval=vusa)
# usast usamt usalt
@johmle(lags=2,vectors=ejoint,dual=djoint,eigenval=vjoint)
# canst canmt canlt usast usamt usalt
*
* Table 5 information
* Note that the eigenvectors produced by <<johmle>> need to be rescaled to match
* the output in the article. Those apparently were produced omitting the T**-1 factor
* in the definition in (19). There is also a sign typo in the 2x2 slot of the dual
* eigenvectors for the Canadian data.
*
disp 'Canada'
disp 'Eigenvalues' #.### vcanada
disp 'Eigenvectors (V)'
disp ##.### ecanada/sqrt(%nobs)
disp 'Eigenvectors (M)'
disp ##.### dcanada/sqrt(%nobs)
*
disp 'United States'
disp 'Eigenvalues' #.### vusa
disp 'Eigenvectors (V)'
disp ##.### eusa/sqrt(%nobs)
disp 'Eigenvectors (M)'
disp ##.### dusa/sqrt(%nobs)
*
disp 'Joint Analysis'
disp 'Eigenvalues' #.### vjoint
disp 'Eigenvectors (V)'
disp ##.### ejoint/sqrt(%nobs)
disp 'Eigenvectors (M)'
disp ##.### djoint/sqrt(%nobs)
*
* p is the number of variables, r is the selected cointegrating rank,
* which means that p-r is the number of common trends.
*
compute r=5,p=6
*
* This equation will make it easier to create linear combinations of
* the variables
*
equation xeqn *
# canst canmt canlt usast usamt usalt
*
* gamma-perp (in GG's notation) will be the final p-r columns in the dual set
* of eigenvectors. alpha (the cointegrating vectors) will be the first r columns
* in the original set of eigenvectors
*
compute gperp=%xsubmat(djoint,1,p,r+1,p)
compute gamma=%perp(gperp)
compute alpha=%xsubmat(ejoint,1,p,1,r)
compute aperp=%perp(alpha)
*
* Compute the a1 and a2 matrices
*
compute a1=aperp*inv(tr(gperp)*aperp)
compute a2=gamma*inv(tr(alpha)*gamma)
*
* Compute the P-T decomposition of the Canadian short rate (variable 1)
*
compute pweight=%xrow(a1*tr(gperp),1)
set pcomp = %dot(pweight,%eqnxvector(xeqn,t))
compute tweight=%xrow(a2*tr(alpha),1)
set tcomp = %dot(tweight,%eqnxvector(xeqn,t))
graph(header='Figure 3. Canada: P-T Decomposition of Short Interest Rate',key=upleft) 3
# canst
# pcomp
# tcomp
*
* Compute the P-T decomposition of the U.S. long term rate (variable 6)
*
compute pweight=%xrow(a1*tr(gperp),6)
set pcomp = %dot(pweight,%eqnxvector(xeqn,t))
compute tweight=%xrow(a2*tr(alpha),6)
set tcomp = %dot(tweight,%eqnxvector(xeqn,t))
graph(header='Figure 4. United States: P-T Decomposition of Long Interest Rate',key=upleft) 3
# usalt
# pcomp
# tcomp
*
* Test the restriction that the gamma perp is a function of U.S. rates only
*
compute m=3
dec rect g(p,m)
ewise g(i,j)=(i==j+3)
compute g00g=tr(g)*%%s00*g
compute g11g=tr(g)*%%s01*inv(%%s11)*tr(%%s01)*g
compute sf=inv(%decomp(g00g))
eigen sf*g11g*tr(sf) eigval eigvec
compute eigvec=tr(sf)*eigvec
disp 'Constrained Weights' g*%xcol(eigvec,m)/sqrt(%nobs)
compute %cdstat=-%nobs*log((1-eigval(m))/(1-vjoint(p)))
cdf(title='Test that common factor can be all U.S.') chisqr %cdstat 6-m

