*
* Replication File for Uhlig (2005), "What are the effects of monetary policy on output?
* Results from an agnostic identification procedure." Journal of Monetary Economics, 52, pp
* 381-419. Penalty function approach
*
open data uhligdata.xls
calendar 1965 1 12
data(format=xls,org=columns) 1965:01 2003:12 gdpc1 gdpdef cprindex totresns bognonbr fedfunds
*
set gdpc1    = log(gdpc1)*100.0
set gdpdef   = log(gdpdef)*100.0
set cprindex = log(cprindex)*100.0
set totresns = log(totresns)*100.0
set bognonbr = log(bognonbr)*100.0
*
system(model=varmodel)
variables gdpc1 gdpdef cprindex fedfunds bognonbr totresns
lags 1 to 12
end(system)
estimate(noprint)
*
dec vect[strings] vl(6)
compute vl=||'real GDP','GDP price defl','Comm. Price Ind.',$
             'Fed Funds Rate','Nonborr. Reserv.','Total Reserves'||
*
* Get the scale factors to be used for impulse responses
*
dec vect scales(6)
dec real func
compute fill=0
dofor i = gdpc1 gdpdef cprindex fedfunds bognonbr totresns
   diff i / diff1
   stats(noprint) diff1
   compute fill=fill+1,scales(fill)=sqrt(%variance)
end dofor i
*
* ndraws is the desired number of draws from the posterior of the VAR
* nvar is the number of variables
* nstep is the number of IRF steps to compute
* KMAX is the "K" value for the number of steps constrained
*
nonlin g1 g2 g3 g4 g5 g6
compute g1=g2=g3=g4=g5=g6=1.0
function alphavect
type vector alphavect
*
compute alphavect=$
 ||cos(g1)*cos(g2)*cos(g3),$
   cos(g1)*cos(g2)*sin(g3),$
   cos(g1)*sin(g2),$
   sin(g1)*cos(g4)*cos(g5),$
   sin(g1)*cos(g4)*sin(g5),$
   sin(g1)*sin(g4)||
end
*
compute ndraws=1000
compute nvar=6
compute nstep=60
compute KMAX=5
declare vect[rect] goodresp(ndraws)
declare vector ik a(nvar)
*
* This is the standard setup for MC integration of an OLS VAR
*
compute sxx    =%decomp(%xx)
compute svt    =%decomp(inv(%nobs*%sigma))
compute betaols=%modelgetcoeffs(varmodel)
compute ncoef  =%rows(sxx)
compute wishdof=%nobs-ncoef
dec rect ranc(ncoef,nvar)
*
infobox(action=define,progress,lower=1,upper=ndraws) 'Monte Carlo Integration'
*
* Plan for double the number of draws to allow for the ones which we
* reject.
*
compute accept=0
do draws=1,ndraws*2
   *
   * Make a draw from the posterior for the VAR and compute its impulse
   * responses.
   *
   compute sigmad  =%ranwisharti(svt,wishdof)
   compute swish   =%decomp(sigmad)
   compute ranc    =%ran(1.0)
   compute betau   =sxx*ranc*tr(swish)
   compute betadraw=betaols+betau
   compute %modelsetcoeffs(varmodel,betadraw)
   impulse(noprint,model=varmodel,decomp=swish,results=impulses,steps=nstep)
   *
   * Minimize the penalty function, starting from the last set of minimizers
   *
   find(noprint) min func
      compute a=alphavect()
      compute func=0.0
      do k=1,KMAX+1
         compute ik=(%xt(impulses,k)*a)./scales
         compute func=func+%if(ik(4)>0,-ik(4),-100*ik(4))+%if(ik(3)<0,ik(3),100*ik(3))+%if(ik(2)<0,ik(2),100*ik(2))+%if(ik(5)<0,ik(5),100*ik(5))
      end do k
   end find
   compute testfunc=func,testbeta=%beta
   *
   * Try the minimization again, starting from a standard set of values
   *
   compute g1=g2=g3=g4=g5=g6=1.0
   find(noprint) min func
      compute a=alphavect()
      compute func=0.0
      do k=1,KMAX+1
         compute ik=(%xt(impulses,k)*a)./scales
         compute func=func+%if(ik(4)>0,-ik(4),-100*ik(4))+%if(ik(3)<0,ik(3),100*ik(3))+%if(ik(2)<0,ik(2),100*ik(2))+%if(ik(5)<0,ik(5),100*ik(5))
      end do k
   end find
   *
   * If the two estimates don't match, reject the draw. If they do, copy out the
   * impulse responses.
   *
   if abs(testfunc-func)<.01 {
      compute accept=accept+1
      dim goodresp(accept)(nstep,nvar)
      ewise goodresp(accept)(i,j)=ik=%xt(impulses,i)*a,ik(j)
   }
   *
   * Map the g's back to equivalent representations close to zero
   *
   compute g1=g1-fix(g1/(2*%pi))*2*%pi
   compute g2=g2-fix(g2/(2*%pi))*2*%pi
   compute g3=g3-fix(g3/(2*%pi))*2*%pi
   compute g4=g4-fix(g4/(2*%pi))*2*%pi
   compute g5=g5-fix(g5/(2*%pi))*2*%pi
   compute g6=g6-fix(g6/(2*%pi))*2*%pi
   *
   * If we've hit out desired number of accepted draws, break
   *
   if accept>=ndraws
      break
   infobox(current=accept)
end do draws
infobox(action=remove)
*
* Post-processing. Graph the mean of the responses along with the 16% and 84%-iles
*
clear upper lower resp
*
spgraph(vfields=3,hfields=2,hlabel='Figure 14. Impulse Responses with Penalty Function Approach')
do i=1,nvar
   compute minlower=maxupper=0.0
   smpl 1 accept
   do k=1,nstep
      set work = goodresp(t)(k,i)
      compute frac=%fractiles(work,||.16,.84||)
      compute lower(k)=frac(1)
      compute upper(k)=frac(2)
      compute resp(k)=%avg(work)
   end do k
*
   smpl 1 nstep
   graph(ticks,number=0,picture='##.##',header='Impulse Responses for '+vl(i)) 3
   # resp
   # upper / 2
   # lower / 2
end do i
*
spgraph(done)


