*
*  Replication File for Uhlig (2005), "What are the effects of monetary policy on output?
*  Results from an agnostic identification procedure." Journal of Monetary Economics, 52, pp
*  381-419
*
open data uhligdata.xls
calendar 1965 1 12
data(format=xls,org=columns) 1965:01 2003:12 gdpc1 gdpdef cprindex totresns bognonbr fedfunds
*
set gdpc1    = log(gdpc1)*100.0
set gdpdef   = log(gdpdef)*100.0
set cprindex = log(cprindex)*100.0
set totresns = log(totresns)*100.0
set bognonbr = log(bognonbr)*100.0
*
system(model=sixvar)
variables gdpc1 gdpdef cprindex fedfunds bognonbr totresns
lags 1 to 12
end(system)
estimate(noprint)
*
dec vect[strings] vl(6)
compute vl=||'real GDP','GDP price defl','Comm. Price Ind.',$
     'Fed Funds Rate','Nonborr. Reserv.','Total Reserves'||
*
* Compute standard impulse response functions
*
compute nvar  =6
compute nsteps=60
compute ndraws=10000
compute KMAX=5

impulse(model=sixvar,steps=nsteps,results=impulses,noprint)
*
dec vect[series] mini(nvar) maxi(nvar)
dec series[vect] oneresp
dec vect a(nvar) atest ik
dec vect[series] impacts(nvar)
*
do i=1,nvar
   set impacts(i) 1 ndraws = %na
end do i
*
do i=1,nvar
   set mini(i) 1 nsteps = 1.e+10
   set maxi(i) 1 nsteps = -1.e+10
end do i
*
compute atilde=%decomp(%sigma)
compute accept=0
do draws=1,ndraws
*
*     Take a draw from the unit circle. This is done by drawing from N(0,I)
*     (which has a spherically symmetric distribution) and normalizing to
*     unit length.
*
   compute a=%ran(1.0),a=a/sqrt(%normsqr(a))
*
*     Transform back to the original variable space
*
   compute atest=atilde*a
*
*     Flip the sign if the FFR shock is negative
*
   if atest(4)<0
      compute a=-1.0*a

   do k=1,KMAX+1
      compute ik=%xt(impulses,k)*a
      if ik(4)<0.or.ik(3)>0.or.ik(2)>0.or.ik(5)>0
         branch 105
   end do k
   gset oneresp 1 nsteps = %xt(impulses,t)*a
   do i=1,nvar
      set maxi(i) 1 nsteps = %max(oneresp{0}(i),maxi(i))
      set mini(i) 1 nsteps = %min(oneresp{0}(i),mini(i))
   end do i
   compute %pt(impacts,draws,ik)
   compute accept=accept+1
:105
end do draws
*
spgraph(vfields=3,hfields=2,hlabel='Figure 2. Range of Impulse Responses with K=5')
do i=1,6
   graph(nodates,number=0,picture='##.#',header='Impulse response for '+vl(i)) 2
   # mini(i)
   # maxi(i)
end do i
spgraph(done)
*
spgraph(vfields=3,hfields=2,hlabel='Figure 3. Distribution of Impact Impulse Response')
do i=1,6
   density(type=hist,counts,maxgrid=20) impacts(i) / fx dx
   set dx = 100.0*dx/accept
   scatter(style=bar,vmin=0.0,vmax=12.0,header='Impulse response for '+vl(i))
   # fx dx
end do i
spgraph(done)
*
* Standard impulse response functions (figure 5)
*
impulse(model=sixvar,steps=60,results=impulses,noprint)
*
spgraph(vfields=3,hfields=2,hlabel='Figure 5. Responses to a Contractionary Monetary Policy Shock')
do i=1,6
   graph(nodates,number=0,picture='##.#',header='Impulse response for '+vl(i))
   # impulses(i,4)
end do i
spgraph(done)



