*
* Example 4 from Terasvirta(1994), "Specification, Estimation and Evaluation of
* Smooth Transition Autoregressive Models", JASA, vol 89, pp 208-218.
*
open data ger4ind.prn
calendar 1961 1 4
data(format=prn,org=columns) 1961:01 1986:04 ipgrowth
*
graph(header="Four-quarter differences of log German IP")
# ipgrowth
*
@yulelags(max=20) ipgrowth
*
* Copy data to series "x" to make the remaining code more standard
*
set x = ipgrowth
*
* Run the STAR tests for table 3
*
source startest.src
do d=1,9
   @StarTest(p=9,d=d) x
end do d
*
nlpar(exactlinesearch)
stats x
compute scalef=1.0/sqrt(%variance)
nonlin(parmset=starparms) gamma c
frml flstar = %logistic(33.5*gamma*(x{4}-c),1.0)
compute c=%mean,gamma=2.0
equation standard x
# constant x{1 to 9}
equation transit x
# constant x{1 to 9}
*
frml(equation=standard,vector=phi1) phi1f
frml(equation=transit ,vector=phi2) phi2f
frml star x = f=flstar,phi1f+f*phi2f
*
nonlin(parmset=regparms) phi1 phi2
nonlin(parmset=starparms) gamma c
nlls(parmset=regparms,frml=star) ipgrowth
*
* This will do the model shown in the article with lag polynomials trimmed.
*
equation standard x
# x{1 4 7}
equation transit x
# x{2 5 7 8 9}
frml(equation=standard,vector=phi1) phi1f
frml(equation=transit ,vector=phi2) phi2f
compute c=%mean,gamma=2.0
nlls(parmset=regparms+starparms,frml=star,trace) x
*
stats %resids
*
* Analysis of roots of the polynomials
*
associate standard phi1
associate transit  phi2
compute upper=standard+transit
*
* The equation <<upper>> is created by adding the right hand sides of the standard
* and transit polynomials.
*
@LagPolyRoots %eqnlagpoly(upper,x)
@LagPolyRoots %eqnlagpoly(standard,x)

