*
* All of this was out of Gray's paper, "Modeling the conditional distribution
* of interest rates as a regime-switching process", J. of Financial Economics 42, 1996, pp 27-62.
*
open data weekly.xls
calendar(weekly) 1970 1 7
all 1994:04:13
data(format=xls,org=columns) 1970:01:07 1994:04:13 rate
*
diff rate / drate
*
stats drate
cmom(center)
# drate rate{1}
*
* Linear regression
*
linreg drate
# constant rate{1}
compute olsvar=%seesq
compute olsbeta=%beta
*
compute nstates=2
*
source markov.src
*
* This is added code for computing smoothed probablities
* pt_t1 will be the ex ante probabilities (that is,
* the probabilities of the states at t given t-1).
* pt_t are the same, but given t.
* psmooth are the probabilities given the entire data set
*
dec rect p(nstates-1,nstates)
dec vect pstar(nstates)
*
dec series[vect] pt_t pt_t1 psmooth
gset pt_t1   = %zeros(nstates,1)
gset pt_t    = %zeros(nstates,1)
gset psmooth = %zeros(nstates,1)
*
* After the maximize instruction which estimates the
* model, use %mssmooth to compute the smoothed probabilities.
*
procedure %mssmooth
local rect pexpand pfull
local integer i j time
*
dim pexpand(nstates,nstates-1)
ewise pexpand(i,j)=%if(i==nstates,-1.0,i==j)
compute pfull=pexpand*p
ewise pfull(i,j)=%if(i==nstates,1.0+pfull(i,j),pfull(i,j))
gset psmooth %regstart() %regend() = pstar
*
do time=%regend()-1,%regstart(),-1
   gset psmooth time time = pt_t.*(tr(pfull)*(psmooth{-1}./pt_t1{-1}))
end do time
end
************************************************************
*
* Estimates for the constant variance regime switching model
*
nonlin a01 a02 a11 a12 b01 b02 p
compute a01=olsbeta(1),a11=olsbeta(2),b01=sqrt(olsvar)
compute a02=a12=0.0,b02=b01
compute p=||.8,.1||
*
function SimpleRegimeF t
type vector SimpleRegimeF
type integer t
*
compute SimpleRegimeF=||%density((drate(t)-a01-a11*rate(t-1))/b01)/b01,%density((drate(t)-a02-a12*rate(t-1))/b02)/b02||
end
*
frml logl = f=SimpleRegimeF(t),$
   pt_t1=%mcstate(p,pstar),pt_t=pstar=%msupdate(f,pt_t1,fpt),log(fpt)
frml init = (pstar=%mcergodic(p)),0
maximize(start=init,method=bfgs,iters=100,pmethod=simplex,piters=5) logl 2 1994:4:13
*
* Compute and graph the smoothed probabilities and the ex ante probabilities
*
@%mssmooth
set exante %regstart() %regend() = pt_t1(t)(1)
set smooth %regstart() %regend() = psmooth(t)(1)
graph 2
# exante
# smooth
*
* Compute and graph the conditional standard deviation
*
set condstddev = sqrt(exante*b01**2+(1-exante)*b02**2)
graph
# condstddev
***********************************************************
*
* Single regime GARCH model
*
garch(p=1,q=1,reg) / drate
# constant rate{1}
compute onestate=%beta
***********************************************************
*
* Regime-switching GARCH
*
nonlin a01 a02 a11 a12 b01 b11 b21 b02 b12 b22 p
compute a01=%beta(1),a11=%beta(2),b01=%beta(3),b11=%beta(4),b21=%beta(5)
compute a02=olsbeta(1),a12=olsbeta(2),b02=olsvar,b12=0.0,b22=0.0
compute p=||.8,.1||
*
set uu = olsvar
set h  = olsvar
*
function RegimeGARCHF t
type vector RegimeGARCHF
type integer t
local real hh1 hh2 mu1 mu2 mu
*
* Compute state dependent variances
*
compute hh1=b01+b11*uu(t-1)+b21*h(t-1)
compute hh2=b02+b12*uu(t-1)+b22*h(t-1)
*
* Compute state dependent means
*
compute mu1=a01+a11*rate(t-1)
compute mu2=a02+a12*rate(t-1)
*
* Compute the return vector (densities in the two states)
*
compute RegimeGARCHF=||%density((drate(t)-mu1)/sqrt(hh1))/sqrt(hh1),%density((drate(t)-mu2)/sqrt(hh2))/sqrt(hh2)||
*
* Compute the values of uu (squared residual) and h (variance) to be used for
* the period following
*
compute mu=mu1*pstar(1)+mu2*pstar(2)
compute uu(t)=(drate(t)-mu)**2
compute h(t)=pstar(1)*(mu1**2+hh1)+pstar(2)*(mu2**2+hh2)-mu**2
end
*
frml logl = f=RegimeGARCHF(t),$
    pt_t1=%mcstate(p,pstar),pt_t=pstar=%msupdate(f,pt_t1,fpt),log(fpt)
frml init = (pstar=%mcergodic(p)),0
maximize(start=init,method=bfgs,iters=100,pmethod=simplex,piters=5) logl 2 *
compute a01=.1407,a02=-.0011,a11=-.0141,a12=.0006,b0=.1870,b11=.4609,b21=.1977,b02=.0099,b12=.1655,b22=.2685,p=||.9739,1-.9896||
maximize(start=init,method=bfgs,iters=100,pmethod=simplex,piters=50,trace) logl 2 *
***********************************************************
* Single regime GRS model
* GARCH can't handle this form of the model because the addition RATE{1} variable
* with the XREG option won't cause the constant in the variance equation to drop out.
* (Not done yet).
***********************************************************
*
* Constant probability GRS model
*
nonlin a01 a02 a11 a12 b11 b21 sig1 b12 b22 sig2 p
function RegimeGRSF t
type vector RegimeGRSF
type integer t
local real hh1 hh2 mu1 mu2 mu
*
* Compute state dependent variances
*
compute hh1=sig1*rate(t-1)+b11*uu(t-1)+b21*h(t-1)
compute hh2=sig2*rate(t-1)+b12*uu(t-1)+b22*h(t-1)
*
* Compute state dependent means
*
compute mu1=a01+a11*rate(t-1)
compute mu2=a02+a12*rate(t-1)
*
* Compute the return vector (densities in the two states)
*
compute RegimeGRSF=||%density((drate(t)-mu1)/sqrt(hh1))/sqrt(hh1),%density((drate(t)-mu2)/sqrt(hh2))/sqrt(hh2)||
*
* Compute the values of uu (squared residual) and h (variance) to be used for
* the period following
*
compute mu=mu1*pstar(1)+mu2*pstar(2)
compute uu(t)=(drate(t)-mu)**2
compute h(t)=pstar(1)*(mu1**2+hh1)+pstar(2)*(mu2**2+hh2)-mu**2
end
*
frml logl = f=RegimeGRSF(t),$
    pt_t1=%mcstate(p,pstar),pt_t=pstar=%msupdate(f,pt_t1,fpt),log(fpt)
frml init = (pstar=%mcergodic(p)),0
compute a01=.0550,a02=.0014,a11=-.0060,a12=.0002,b11=.3038,b21=.0936,sig1=.1550,b12=.1528,b22=.2383,sig2=.0420,p=||.9688,1-.9881||
maximize(start=init,method=bfgs,iters=100,pmethod=simplex,piters=5) logl 2 *
***********************************************************
* Time varying probability GRS model
*
stats(noprint) rate
compute avgrate=%mean
*
nonlin a01 a02 a11 a12 b11 b21 sig1 b12 b22 sig2 c1 d1 c2 d2
frml logl = p=||%cdf(c1+d1*rate{1}),%cdf(-c2-d2*rate{1})||,f=RegimeGRSF(t),$
    pt_t1=%mcstate(p,pstar),pt_t=pstar=%msupdate(f,pt_t1,fpt),log(fpt)
frml init = (pstar=%mcergodic(||%cdf(c1+d1*avgrate),%cdf(-c2-d2*avgrate)||)),0
compute a01=.0550,a02=.0014,a11=-.0060,a12=.0002,b11=.3038,b21=.0936,sig1=.1550,b12=.1528,b22=.2383,sig2=.0420,p=||.9688,1-.9881||
compute c1=c2=%invnormal(.95),d1=d2=0.0
maximize(start=init,method=bfgs,iters=100,pmethod=simplex,piters=5) logl 2 *


