*
* Replication file for Jordi Gali, "Technology, Employment and the Business
* Cycle: Do Technology Shocks Explain Aggregate Fluctuations", American Economic
* Review, 1999, vol 89, pp 249-271.
*
* This file does the two variable model. If you run this as written, you'll get
* the results for the U.S. data with first differenced hours. Changing the setting
* of difn to 'no' will do the analysis with detrended hours (Panel B). Changing
* nchoice to 1 will do the analysis for employment.
*
* Most of this was provided by J. Gali. Some changes were made to improve
* readability (mainly indenting loops), some loops were eliminated through use of
* the SSTATS instruction, and the setup of the VAR's has been modernized to use
* the MODELS instead of numbered equations.
*
cal 1947 1 4
open data data.rat
data(format=rats,org=obs) 1947:1 1994:4

****US Data*********************************************************
*data(format=citibase) / gdpq lhem lpmhu p16
****International Data**********************************************
*open data d:\data\oecd\oecdq.rat
*data(format=rats,org=obs) 60:1 94:4 cann gbrn deun fran itan jpnn espn
*open data d:\data\mei\canoecd.rat
*data(format=rats,org=obs) 60:1 94:4 canrgdp
*open data d:\data\mei\gbroecd.rat
*data(format=rats,org=obs) 60:1 94:4 gbrrgdp
*open data d:\data\mei\deuoecd.rat
*data(format=rats,org=obs) 60:1 94:4 fdrrgdps
*open data d:\data\mei\fraoecd.rat
*data(format=rats,org=obs) 70:1 94:4 frargdp
*open data d:\data\mei\itaoecd.rat
*data(format=rats,org=obs) 70:1 94:4 itargdp
*open data d:\data\mei\jpnoecd.rat
*data(format=rats,org=obs) 60:1 94:4 jpngnp85
*open data d:\data\mei\espoecd.rat
*data(format=rats,org=obs) 70:1 94:4 espgdpvs
*************************

COMPUTE country = 'US'

COMPUTE nchoice = 2
**(1) n: employment
**(2) n: hours

COMPUTE nint = 1
**(1) n=I(1)
**(0) n=I(0)

COMPUTE difn = 'yes'
**'yes' computed correlations based on employment growth
**'no' computed correlations based on detrended employment

COMPUTE LAGS=4
COMPUTE NVAR=2
COMPUTE NSTEP= 100
COMPUTE NDRAWS= 500
COMPUTE NSE = 2
COMPUTE IRH = 13
COMPUTE NW = 6

**************************************
**************************************
**************************************

if nchoice==1
   compute labor = 'employment'
else if nchoice==2
   compute labor = 'hours'
end if
display @1 country
display @20 'n:' labor @40 'I(' nint ')'
display ''

set nber = 0.0


if country== 'US'
{
   compute fp = 1948:1
   compute lp = 1994:4

   set yx fp lp = gdpq
   set nber fp lp = T>=1948:4.and.T<=1949:4.or.$
           T>=1953:2.and.T<=1954:2.or.T>=1957:4.and.T<=1958:2.or.$
           T>=1960:2.and.T<=1961:1.or.T>=1969:4.and.T<=1970:4.or.$
           T>=1973:4.and.T<=1975:1.or.T>=1980:1.and.T<=1980:3.or.$
           T>=1981:3.and.T<=1982:4.or.T>=1990:3.and.T<=1991:1
   set nberg fp lp = T==1948:4.or.T==1949:4.or.$
           T==1953:2.or.T==1954:2.or.T==1957:4.or.T==1958:2.or.$
           T==1960:2.or.T==1961:1.or.T==1969:4.or.T==1970:4.or.$
           T==1973:4.or.T==1975:1.or.T==1980:1.or.T==1980:3.or.$
           T==1981:3.or.T==1982:4.or.T==1990:3.or.T==1991:1

   if nchoice==1
      set nx fp lp = lhem
   else if nchoice==2
      set nx fp lp = lpmhu
}
else if country=='FRANCE'
{
   compute fp = 1970:1
   compute lp = 1994:4
   smpl fp lp
   set yx fp lp = frargdp
   set nx fp lp = fran
}
else if country=='SPAIN'
{
   compute fp = 1970:1
   compute lp = 1994:4
   smpl fp lp
   set yx fp lp = espgdpvs
   set nx fp lp = espn
}
else if country=='CANADA'
{
   compute fp = 1962:1
   compute lp = 1994:4
   set yx fp lp = canrgdp
   set nx fp lp = cann
}
else if country=='UK'
{
   compute fp = 1962:1
   compute lp = 1994:3
   set yx fp lp = gbrrgdp
   set nx fp lp = gbrn
}
else if country=='JAPAN'
{
   compute fp = 1962:1
   compute lp = 1994:4
   set yx fp lp = jpngnp85
   set nx fp lp = jpnn
}
else if country=='GERMANY'
{
   compute fp = 1970:1
   compute lp = 1994:4
   set yx fp lp = fdrrgdps
   set nx fp lp = deun
}
else if country=='ITALY'
{
   compute fp = 1970:1
   compute lp = 1994:3
   set yx fp lp = itargdp
   set nx fp lp = itan
}
end if

compute nobs = lp-fp

*****************************
set xx = yx/nx

set(scratch) y = 100.+ 100.*log(yx/yx(fp))
set(scratch) n = 100.+ 100.*log(nx/nx(fp))
set(scratch) x = 100.+ 100.*log(xx/xx(fp))

difference y / dy
difference n / dn
difference x / dx

difference dy / d2y
difference dn / d2n
difference dx / d2x

filter(type=hp,tuning=1600) y / yhpt
set yhp = y - yhpt
filter(type=hp,tuning=1600) n / nhpt
set nhp = n - nhpt
filter(type=hp,tuning=1600) x / xhpt
set xhp = x - xhpt

**************************************************************
***************************************unit root tests********
**************************************************************

display 'ADF unit root tests (4 lags): t-statistic'

@dfunit(noprint,trend,lags=4) y
display 'y:' @30 #.## %cdstat

@dfunit(noprint,trend,lags=4) n
display 'n:' @30 #.## %cdstat

@dfunit(noprint,trend,lags=4) x
display 'x:' @30 #.## %cdstat

@dfunit(noprint,trend,lags=4) dx
display 'dx:' @30 #.## %cdstat

************************************
******basic statistics**************
************************************

smpl fp+1 lp

statistics(noprint) dy
compute dyv = %variance
statistics(noprint) dx
compute dxv = %variance
compute dxm = %mean
statistics(noprint) dn
compute dnv = %variance
compute dnm = %mean

statistics(noprint) yhp
compute yhpv = %variance
statistics(noprint) xhp
compute xhpv = %variance
statistics(noprint) nhp
compute nhpv = %variance



**************************
*selection of variables***
* Transform "n"
**************************

set trend = t

linreg(noprint) n / nres
# constant trend

statistics(noprint) nres
compute nresv = %variance

if nint==0
{
   compute [string] trans = 'detrended'
   set dnz = nres
}
else if nint==1
{
   compute [string] trans = 'first differences'
   set dnz = dn
}
end if

if nint==0.and.difn=='no'
{
   set dn = nres
}
end if


**************************************
****unconditional cross correlograms**
**************************************

smpl fp+1 lp

cross(noprint) dy dx / -nstep nstep cdydx
cross(noprint) dy dn / -nstep nstep cdydn
cross(noprint) dx dn / -nstep nstep cdxdn

cross(noprint) yhp xhp / -nstep nstep cyxhp
cross(noprint) yhp nhp / -nstep nstep cynhp
cross(noprint) xhp nhp / -nstep nstep cxnhp

**
** standard error for unconditional covariance (GMM)
**

set dxdn = (dx-dxm)*(dn-dnm)

**
** The following calculation is not quite correct. The I in the DO
** loop should run from 1 to NW, with acdxdn(I+1) used in place
** of acdxdn(I). The difference should be fairly minor as the code
** just weights the covariances incorrectly.
**
correlate(covariances,noprint) dxdn / acdxdn
compute sacdxdn = acdxdn(1)
do I=2,NW
   compute sacdxdn = sacdxdn + 2.0*(1.0-(I/(NW+1.0)))*acdxdn(I)
end do I
*
* This is a simpler way to do the calculation of sacdxdn. (It's commented
* out to allow replication of the published results).
*
*mcov(lwindow=bartlett,lags=nw,center)
*# dxdn
*compute sacdxdn=%cmom(1,1)/%nobs
*
compute sdcdxdn = sqrt(sacdxdn/nobs)/sqrt(dnv*dxv)
compute pcdxdn = 2.0*(1.0-%cdf(abs(cdxdn(nstep+1))/sdcdxdn) )


*************************
*****reduced form var****
*************************

smpl fp+1 lp

system(model=varmodel)
variables dx dnz
lags 1 to lags
det constant
end(system)

estimate(outsigma=sigmat,noprint,noftests,resids=resvar)
write
write 'covariance of innovations:'
write  sigmat
write

dec rect[series] e(2,2)
declare rectangular emats(2,2)
declare symmetric esemat(2,2)
*
*  Compute long-run IRF's
*
impulse(model=varmodel,decomp=%identity(2),results=e,noprint) * nstep
sstats 1 nstep e(1,1)>>emats(1,1) e(1,2)>>emats(1,2) e(2,1)>>emats(2,1) e(2,2)>>emats(2,2)

compute esemat = emats*sigmat*tr(emats)
compute cmats = %decomp(esemat)
compute smat = inv(emats)*cmats
compute sinv = inv(smat)


*****************************
****structural var***********
*****************************

****shocks analysis
set eps1 = sinv(1,1)*resvar(1)+sinv(1,2)*resvar(2)
set eps2 = sinv(2,1)*resvar(1)+sinv(2,2)*resvar(2)

****impulse responses

impulse(model=varmodel,noprint,decomp=smat,results=imp) * nstep

set c11  1 nstep = imp(1,1)
set c21z 1 nstep = imp(2,1)
set c12  1 nstep = imp(1,2)
set c22z 1 nstep = imp(2,2)

if nint==0.and.difn=='yes'
{
   set c21 1 1 = c21z
   set c21 2 nstep = c21z - c21z{1}
   set c22 1 1 = c22z
   set c22 2 nstep = c22z - c22z{1}
}
else
{
   set c21 1 nstep = c21z
   set c22 1 nstep = c22z
}
end if

set c31 1 nstep = c11 + c21
set c32 1 nstep = c12 + c22

accumulate c11 1 nstep c11s
accumulate c12 1 nstep c12s
accumulate c21 1 nstep c21s
accumulate c22 1 nstep c22s
accumulate c31 1 nstep c31s
accumulate c32 1 nstep c32s

if nint==0.and.difn=='no'
{
   set c21s 1 nstep = c21
   set c22s 1 nstep = c22
}
end if


*************EXPORTING DATA***********
**change labels !

*smpl 1 irh
*set canyt = c31s
*set cannt = c21s
*set canxt = c11s
*set canyd = c32s
*set cannd = c22s
*set canxd = c12s

*dedit(new) f5can.rat
*store canyt cannt canxt canyd cannd canxd
*save

*dedit(new) f5gbr.rat
*store gbryt gbrnt gbrxt gbryd gbrnd gbrxd
*save

*dedit(new) f5deu.rat
*store deuyt deunt deuxt deuyd deund deuxd
*save

*dedit(new) f5fra.rat
*store frayt frant fraxt frayd frand fraxd
*save

*dedit(new) f5ita.rat
*store itayt itant itaxt itayd itand itaxd
*save

*dedit(new) f5jpn.rat
*store jpnyt jpnnt jpnxt jpnyd jpnnd jpnxd
*save



***conditional variances

sstats 1 nstep c11**2>>vxt c21**2>>vnt c31**2>>vyt c12**2>>vxd c22**2>>vnd c32**2>>vyd
sstats 1 nstep c11*c21>>corxntpe c12*c22>>corxndpe

***conditional correlations based on MA coefficients

compute corxntpe = corxntpe/sqrt(vxt*vnt)
compute corxndpe = corxndpe/sqrt(vxd*vnd)


***standard error bands for null hypothesis of no response

if nint==1
   compute dnv = dnv
else if nint==0
   compute dnv = nresv
end if

compute nobs = lp-fp

set yse1 1 nstep = nse*sqrt(dyv)/sqrt(nobs)
set yse2 1 nstep = -yse1
set xse1 1 nstep = nse*sqrt(dxv)/sqrt(nobs)
set xse2 1 nstep = -xse1
set nse1 1 nstep = nse*sqrt(dnv)/sqrt(nobs)
set nse2 1 nstep = -nse1


**************************************************
****variance decomposition (original)*************
**************************************************

set c112 1 nstep = c11**2
set c122 1 nstep = c12**2
set c212 1 nstep = c21**2
set c222 1 nstep = c22**2
set c312 1 nstep = c31**2
set c322 1 nstep = c32**2

accumulate c112 1 nstep c112s
accumulate c122 1 nstep c122s
accumulate c212 1 nstep c212s
accumulate c222 1 nstep c222s
accumulate c312 1 nstep c312s
accumulate c322 1 nstep c322s

set v11 1 nstep = c112s/(c112s+c122s)
set v12 1 nstep = c122s/(c112s+c122s)
set v21 1 nstep = c212s/(c212s+c222s)
set v22 1 nstep = c222s/(c212s+c222s)
set v31 1 nstep = c312s/(c312s+c322s)
set v32 1 nstep = c322s/(c312s+c322s)

*******************************************
****variance decomposition (integrated)****
*******************************************

set c11s2 1 nstep = c11s**2
set c12s2 1 nstep = c12s**2
set c21s2 1 nstep = c21s**2
set c22s2 1 nstep = c22s**2
set c31s2 1 nstep = c31s**2
set c32s2 1 nstep = c32s**2

accumulate c11s2 1 nstep c11s2s
accumulate c12s2 1 nstep c12s2s
accumulate c21s2 1 nstep c21s2s
accumulate c22s2 1 nstep c22s2s
accumulate c31s2 1 nstep c31s2s
accumulate c32s2 1 nstep c32s2s

set var11 1 nstep = c11s2s/(c11s2s+c12s2s)
set var12 1 nstep = c12s2s/(c11s2s+c12s2s)
set var21 1 nstep = c21s2s/(c21s2s+c22s2s)
set var22 1 nstep = c22s2s/(c21s2s+c22s2s)
set var31 1 nstep = c31s2s/(c31s2s+c32s2s)
set var32 1 nstep = c32s2s/(c31s2s+c32s2s)


****************
****History*****
****************

history(model=varmodel,decomp=smat,results=decomp) * lp-(fp+lags) fp+lags+1

set hd11  = decomp(2,1)
set hd12  = decomp(3,1)
set hd21z = decomp(2,2)
set hd22z = decomp(3,2)

if nint==0.and.difn=='yes'
{
   set hd21 fp+lags+1 fp+lags+1 = hd21z
   set hd22 fp+lags+1 fp+lags+1 = hd22z
   set hd21 fp+lags+2 lp = hd21z-hd21z{1}
   set hd22 fp+lags+2 lp = hd22z-hd22z{1}
}
else
{
   set hd21 fp+lags+1 lp = hd21z
   set hd22 fp+lags+1 lp = hd22z
}
end if

set hd31 fp+lags+1 lp = hd21 + hd11
set hd32 fp+lags+1 lp = hd22 + hd12

set dyt fp+lags+1 lp = hd31
set dnt fp+lags+1 lp = hd21
set dxt fp+lags+1 lp = hd11
set dyd fp+lags+1 lp = hd32
set dnd fp+lags+1 lp = hd22
set dxd fp+lags+1 lp = hd12

accumulate dyt fp+lags+1 lp yt
accumulate dyd fp+lags+1 lp yd
accumulate dxt fp+lags+1 lp xt
accumulate dxd fp+lags+1 lp xd
accumulate dnt fp+lags+1 lp nt
accumulate dnd fp+lags+1 lp nd

if nint==0.and.difn=='no'
{
   set nt fp+lags+1 lp = dnt
   set nd fp+lags+1 lp = dnd
}
end if

filter(type=hp,tuning=1600) yt / ythpt
set ythp = yt - ythpt
filter(type=hp,tuning=1600) nt / nthpt
set nthp = nt - nthpt
filter(type=hp,tuning=1600) xt / xthpt
set xthp = xt - xthpt
filter(type=hp,tuning=1600) yd / ydhpt
set ydhp = yd - ydhpt
filter(type=hp,tuning=1600) nd / ndhpt
set ndhp = nd - ndhpt
filter(type=hp,tuning=1600) xd / xdhpt
set xdhp = xd - xdhpt


************************************
****UNCONDITIONAL STATISTICS********
************************************

*******growth rates

display @10 'unconditional statistics (I): growth rates'
display ''
display ''
display 'corr(dy,dx)' @40 #.## cdydx(nstep+1)
display 'corr(dy,dn)' @40 #.## cdydn(nstep+1)
display 'corr(dx,dn)' @40 #.## cdxdn(nstep+1)
display 's.e. for corr(dx,dn)' @40 #.### sdcdxdn
display 'p-value for corr(dx,dn)=0' @40 #.### pcdxdn

display ''

*******hp-filtered

display @10 'unconditional statistics (I): hp-filter'
display ''
display ''
display 'corr(yhp,xhp)' @40 #.## cyxhp(nstep+1)
display 'corr(yhp,nhp)' @40 #.## cynhp(nstep+1)
display 'corr(xhp,nhp)' @40 #.## cxnhp(nstep+1)
display ''


************************************
******Conditional Statistics********
************************************

*******growth rates
display @10 'conditional statistics (I): growth rates'
display ''
display 'technology component:'
display ''
statistics(noprint) dyt
compute dytv = %variance
statistics(noprint) dxt
compute dxtv = %variance
statistics(noprint) dnt
compute dntv = %variance

cross(noprint) dyt dxt / -nstep nstep cdytdxt
cross(noprint) dyt dnt / -nstep nstep cdytdnt
cross(noprint) dxt dnt / -nstep nstep cdxtdnt

display 'var(dyt)/var(dy)' @40 #.## dytv/dyv
display 'var(dnt)/var(dn)' @40 #.## dntv/dnv
display 'var(dxt)/var(dx)' @40 #.## dxtv/dxv
display 'corr(dyt,dxt)' @40 #.## cdytdxt(nstep+1)
display 'corr(dyt,dnt)' @40 #.## cdytdnt(nstep+1)
display 'corr(dxt,dnt)' @40 #.## cdxtdnt(nstep+1)
display 'corr(dxt,dnt) (based on MA coeff.)' @40 #.## corxntpe


display ''
display ''
display 'demand shock component:'
display ''
statistics(noprint) dyd
compute dydv = %variance
statistics(noprint) dxd
compute dxdv = %variance
statistics(noprint) dnd
compute dndv = %variance

cross(noprint) dyd dxd / -nstep nstep cdyddxd
cross(noprint) dyd dnd / -nstep nstep cdyddnd
cross(noprint) dxd dnd / -nstep nstep cdxddnd

display 'var(dyd)/var(dy)' @40 #.## dydv/dyv
display 'var(dnd)/var(dn)' @40 #.## dndv/dnv
display 'var(dxd)/var(dx)' @40 #.## dxdv/dxv
display 'corr(dyd,dxd)' @40 #.## cdyddxd(nstep+1)
display 'corr(dyd,dnd)' @40 #.## cdyddnd(nstep+1)
display 'corr(dxd,dnd)' @40 #.## cdxddnd(nstep+1)
display 'corr(dxd,dnd) (based on MA coeff.)' @40 #.## corxndpe
display ''
display ''


*****HP-detrended

display @10 'conditional statistics (II): HP-detrended'
display ''
display 'technology component:'
display ''
statistics(noprint) ythp
compute ythpv = %variance
statistics(noprint) xthp
compute xthpv = %variance
statistics(noprint) nthp
compute nthpv = %variance

cross(noprint) ythp xthp / -nstep nstep cyxhpt
cross(noprint) ythp nthp / -nstep nstep cynhpt
cross(noprint) xthp nthp / -nstep nstep cxnhpt

display 'var(ythp)/var(yhp)' @40 #.## ythpv/yhpv
display 'var(nthp)/var(nhp)' @40 #.## nthpv/nhpv
display 'var(xthp)/var(xhp)' @40 #.## xthpv/xhpv
display 'corr(ythp,xthp)' @40 #.## cyxhpt(nstep+1)
display 'corr(ythp,nthp)' @40 #.## cynhpt(nstep+1)
display 'corr(xthp,nthp)' @40 #.## cxnhpt(nstep+1)
display ''
display ''
display 'demand shock component:'
display ''
statistics(noprint) ydhp
compute ydhpv = %variance
statistics(noprint) xdhp
compute xdhpv = %variance
statistics(noprint) ndhp
compute ndhpv = %variance

cross(noprint) ydhp xdhp / -nstep nstep cyxhpd
cross(noprint) ydhp ndhp / -nstep nstep cynhpd
cross(noprint) xdhp ndhp / -nstep nstep cxnhpd

display 'var(ydhp)/var(yhp)' @40 #.## ydhpv/yhpv
display 'var(ndhp)/var(nhp)' @40 #.## ndhpv/nhpv
display 'var(xdhp)/var(xhp)' @40 #.## xdhpv/xhpv
display 'corr(ydhp,xdhp)' @40 #.## cyxhpd(nstep+1)
display 'corr(ydhp,ndhp)' @40 #.## cynhpd(nstep+1)
display 'corr(xdhp,ndhp)' @40 #.## cxnhpd(nstep+1)
display ''
display ''


*************ESTIMATING SRIRL

*linreg(robusterrors,lags=4,damp=1) dy
*# constant dn

*linreg(robusterrors,lags=4,damp=1) dy
*# constant dnd

******************************************************
******************************************************
*****M O N T E C A R L O  S I M U L A T I O N S ******
******************************************************
******************************************************
smpl fp+1 lp

system(model=varmodel)
variables dx dnz
lags 1 to lags
det constant
end(system)

estimate(noprint,outsigma=vmat)

declare rect sxx svt swish betaols betadraw
declare symm sigmad

compute sxx    =%decomp(%xx)
compute svt    =%decomp(inv(%nobs*vmat))
compute betaols=%modelgetcoeffs(varmodel)
compute ncoef  =%rows(sxx)
compute wishdof=%nobs-ncoef
declare rect ranc(ncoef,nvar)

compute fcorxnt = 0.0
compute fcorxnd = 0.0
compute scorxnt = 0.0
compute scorxnd = 0.0

set fxt 1 nstep = 0.0
set fxd 1 nstep = 0.0
set fnt 1 nstep = 0.0
set fnd 1 nstep = 0.0
set fyt 1 nstep = 0.0
set fyd 1 nstep = 0.0

set sxt 1 nstep = 0.0
set sxd 1 nstep = 0.0
set snt 1 nstep = 0.0
set snd 1 nstep = 0.0
set syt 1 nstep = 0.0
set syd 1 nstep = 0.0

set fxts 1 nstep = 0.0
set fxds 1 nstep = 0.0
set fnts 1 nstep = 0.0
set fnds 1 nstep = 0.0
set fyts 1 nstep = 0.0
set fyds 1 nstep = 0.0

set sxts 1 nstep = 0.0
set sxds 1 nstep = 0.0
set snts 1 nstep = 0.0
set snds 1 nstep = 0.0
set syts 1 nstep = 0.0
set syds 1 nstep = 0.0


***beginning of simulation

do draws = 1,ndraws
   compute sigmad  =%ranwisharti(svt,wishdof)
   compute swish   =%decomp(sigmad)
   compute ranc    =%ran(1.0)
   compute betau   =sxx*ranc*tr(swish)
   compute betadraw=betaols+betau
   compute %modelsetcoeffs(varmodel,betadraw)

   ***reduced form

   impulse(model=varmodel,noprint,decomp=%identity(2),results=e) * nstep
   sstats 1 nstep e(1,1)>>emats(1,1) e(1,2)>>emats(1,2) e(2,1)>>emats(2,1) e(2,2)>>emats(2,2)
   compute esemat = emats*sigmad*tr(emats)
   compute cmats = %decomp(esemat)
   compute sdraw = inv(emats)*cmats

   *******structural

   impulse(model=varmodel,noprint,decomp=sdraw,results=imp) * nstep
   if nint==0.and.difn=='yes'
   {
      set(first=imp(1,2)) impnt 1 nstep = imp(1,2)-imp(1,2){1}
      set(first=imp(2,2)) impnd 1 nstep = imp(2,2)-imp(2,2){1}
   }
   else
   {
      set impnt 1 nstep = imp(1,2)
      set impnd 1 nstep = imp(2,2)
   }
   set impxt 1 nstep = imp(1,1)
   set impxd 1 nstep = imp(2,1)

   set impyt 1 nstep = impxt + impnt
   set impyd 1 nstep = impxd + impnd

   accumulate impxt 1 nstep impxts
   accumulate impnt 1 nstep impnts
   accumulate impyt 1 nstep impyts
   accumulate impxd 1 nstep impxds
   accumulate impnd 1 nstep impnds
   accumulate impyd 1 nstep impyds

   set imp2xt 1 nstep = impxt**2
   set imp2nt 1 nstep = impnt**2
   set imp2yt 1 nstep = impyt**2
   set imp2xd 1 nstep = impxd**2
   set imp2nd 1 nstep = impnd**2
   set imp2yd 1 nstep = impyd**2

   set imp2xts 1 nstep = impxts**2
   set imp2nts 1 nstep = impnts**2
   set imp2yts 1 nstep = impyts**2
   set imp2xds 1 nstep = impxds**2
   set imp2nds 1 nstep = impnds**2
   set imp2yds 1 nstep = impyds**2


   **conditional variances

   sstats 1 nstep imp2xt>>vxt imp2nt>>vnt imp2yt>>vyt imp2xd>>vxd imp2nd>>vnd imp2yd>>vyd

   *******************
   **impulse responses
   *******************
   do J = 1,NSTEP

      compute fxt(J) = fxt(J)+impxt(J)*(1./NDRAWS)
      compute fxd(J) = fxd(J)+impxd(J)*(1./NDRAWS)
      compute fnt(J) = fnt(J)+impnt(J)*(1./NDRAWS)
      compute fnd(J) = fnd(J)+impnd(J)*(1./NDRAWS)
      compute fyt(J) = fyt(J)+impyt(J)*(1./NDRAWS)
      compute fyd(J) = fyd(J)+impyd(J)*(1./NDRAWS)

      compute sxt(J) = sxt(J)+imp2xt(J)*(1./NDRAWS)
      compute sxd(J) = sxd(J)+imp2xd(J)*(1./NDRAWS)
      compute snt(J) = snt(J)+imp2nt(J)*(1./NDRAWS)
      compute snd(J) = snd(J)+imp2nd(J)*(1./NDRAWS)
      compute syt(J) = syt(J)+imp2yt(J)*(1./NDRAWS)
      compute syd(J) = syd(J)+imp2yd(J)*(1./NDRAWS)

      compute fxts(J) = fxts(J)+impxts(J)*(1./NDRAWS)
      compute fxds(J) = fxds(J)+impxds(J)*(1./NDRAWS)
      compute fnts(J) = fnts(J)+impnts(J)*(1./NDRAWS)
      compute fnds(J) = fnds(J)+impnds(J)*(1./NDRAWS)
      compute fyts(J) = fyts(J)+impyts(J)*(1./NDRAWS)
      compute fyds(J) = fyds(J)+impyds(J)*(1./NDRAWS)

      compute sxts(J) = sxts(J)+imp2xts(J)*(1./NDRAWS)
      compute sxds(J) = sxds(J)+imp2xds(J)*(1./NDRAWS)
      compute snts(J) = snts(J)+imp2nts(J)*(1./NDRAWS)
      compute snds(J) = snds(J)+imp2nds(J)*(1./NDRAWS)
      compute syts(J) = syts(J)+imp2yts(J)*(1./NDRAWS)
      compute syds(J) = syds(J)+imp2yds(J)*(1./NDRAWS)

    end do J


    ***************************
    **conditional correlations
    ***************************

    ***growth rates (based on estimated ma coefficients)

    sstats 1 nstep impxt*impnt>>corxnt impxd*impnd>>corxnd

    compute corxnt = corxnt/sqrt(vxt*vnt)
    compute corxnd = corxnd/sqrt(vxd*vnd)

    compute fcorxnt = fcorxnt + corxnt*(1./NDRAWS)
    compute fcorxnd = fcorxnd + corxnd*(1./NDRAWS)

    compute scorxnt = scorxnt + (corxnt**2)*(1./NDRAWS)
    compute scorxnd = scorxnd + (corxnd**2)*(1./NDRAWS)


end do draws


**standard errors for conditional correlations

compute sdcorxnt = sqrt(scorxnt-fcorxnt**2)
compute sdcorxnd = sqrt(scorxnd-fcorxnd**2)

**p-values for null of zero covariance

compute pxnt = 2.0*(1.0-%cdf(abs(corxntpe)/sdcorxnt))
compute pxnd = 2.0*(1.0-%cdf(abs(corxndpe)/sdcorxnd))


**standard errors for impulse responses

set sdxt 1 nstep = sqrt(sxt-fxt**2)
set sdxd 1 nstep = sqrt(sxd-fxd**2)
set sdnt 1 nstep = sqrt(snt-fnt**2)
set sdnd 1 nstep = sqrt(snd-fnd**2)
set sdyt 1 nstep = sqrt(syt-fyt**2)
set sdyd 1 nstep = sqrt(syd-fyd**2)

set sdxts 1 nstep = sqrt(sxts-fxts**2)
set sdxds 1 nstep = sqrt(sxds-fxds**2)
set sdnts 1 nstep = sqrt(snts-fnts**2)
set sdnds 1 nstep = sqrt(snds-fnds**2)
set sdyts 1 nstep = sqrt(syts-fyts**2)
set sdyds 1 nstep = sqrt(syds-fyds**2)

set c11sa 1 nstep = c11s + nse * sdxts
set c11sb 1 nstep = c11s - nse * sdxts
set c31sa 1 nstep = c31s + nse * sdyts
set c31sb 1 nstep = c31s - nse * sdyts
set c21sa 1 nstep = c21s + nse * sdnts
set c21sb 1 nstep = c21s - nse * sdnts

set c12sa 1 nstep = c12s + nse * sdxds
set c12sb 1 nstep = c12s - nse * sdxds
set c32sa 1 nstep = c32s + nse * sdyds
set c32sb 1 nstep = c32s - nse * sdyds
set c22sa 1 nstep = c22s + nse * sdnds
set c22sb 1 nstep = c22s - nse * sdnds


************************************
******Conditional Correlations******
******(with Standard Errors)********
************************************

*******growth rates
display ''
display ''
display '************************************************'
display 'Conditional Employment-Productivity Correlations'
display '************************************************'
display '************************************************'
display 'Montecarlo Simulations'
display '************************************************'


display '(a) Growth Rates'
display '*******************'
display 'Technology component:'
display ''
display 'point estimate = ' @50 #.## corxntpe
display 'mean (MA coefficients) =' @50 #.## fcorxnt
display 's.e. (MA coefficients) = ' @50 #.## sdcorxnt
display 'p-value = ' @50 #.#### pxnt
display ''
display ''
display 'Non-Technology component:'
display ''
display 'point estimate = ' @50 #.## corxndpe
display 'mean (MA coefficients) =' @50 #.## fcorxnd
display 's.e. (MA coefficients) = ' @50 #.## sdcorxnd
display 'p-value = ' @50 #.#### pxnd
display ''
display ''



**************************************
**************************************
*************EXPORTING DATA***********
**************************************
******************************************************** change labels !
*set us2dy = dy
*set us2dn = dn
*set us2dx = dx
*set us2dyt = dyt
*set us2dnt = dnt
*set us2dxt = dxt
*set us2dyd = dyd
*set us2dnd = dnd
*set us2dxd = dxd

*dedit figure5.rat
*store us2dy us2dn us2dx us2dyt us2dnt us2dxt us2dyd us2dnd us2dxd
*save

********************************************
**************************graphs************
********************************************

*********************basic data plots
grparm(noportrait)
spgraph(vfields=3)
graph(key=upleft,header=country+' data') 3
# y fp lp
# n fp lp
# x fp lp
graph(key=upleft) 2
# dy fp+1 lp
# dn fp+1 lp
graph(key=upleft) 2
# dx fp+1 lp
# dn fp+1 lp
spgraph(done)


***Do technology shocks generate recognizable BC ?
***(HP filter,NBER dates)

labels ydhp ndhp
# 'gdp' labor
grparm(noportrait)
spgraph(vfields=2,hfields=1,window='Figure 6 - Estimated Components')
*graph(header='Figure A-5: Decomposing the Business Cycle (Detrended Hours)',$
graph($
      subhead='Technology Component (hp-filtered)',$
      max=4.0,min=-4.0,grid=nberg,style=line) 2
# ythp fp+1 lp 1
# nthp fp+1 lp 2
graph(samesize,subhead='Non-Technology Component (hp-filtered)',$
      key=below,style=line,grid=nberg,max=4.0,min=-4.0) 2
# ydhp fp+1 lp 1
# ndhp fp+1 lp 2
spgraph(done)


***labor market diagrams (NEW)
compute [string] lmhead = 'Figure 1: productivity-'+labor+' '+ ' comovements'
compute [string] lmsub = country + ' data'+ ',' + labor + ',' + trans

grparm(portrait)
*spgraph(vfields=3,hfields=1,header=lmhead,subhead=lmsub )
spgraph(vfields=3,hfields=1,window='Figure 1 Productivity vs Hours')
scatter(style=symbol,vlabel='productivity',hlabel=labor,header='Data') 1
# dn dx
scatter(samesize,style=symbol,vlabel='productivity',hlabel=labor,header='Technology Component') 1
# dnt dxt
scatter(samesize,style=symbol,vlabel='productivity',hlabel=labor,header='Non-Technology Component') 1
# dnd dxd
spgraph(done)



***labor market diagrams (OLD)
grparm(noportrait)
spgraph(vfields=3,hfields=2,window='Figure 1(old) Productivity vs Hours')
scatter(header=country+ '  (growth rates)',style=symbol,vlabel='productivity',hlabel=labor,subhead='data') 1
# dn dx
scatter(samesize,style=symbol,vlabel='productivity',hlabel=labor,subhead='technology component') 1
# dnt dxt
scatter(samesize,style=symbol,vlabel='productivity',hlabel=labor,subhead='demand component') 1
# dnd dxd
scatter(header=country+'   (hp filter)',samesize,style=symbol,vlabel='productivity',hlabel=labor,subhead='data') 1
# nhp xhp
scatter(samesize,style=symbol,vlabel='productivity',hlabel=labor,subhead='technology component') 1
# nthp xthp
scatter(samesize,style=symbol,vlabel='productivity',hlabel=labor,subhead='demand component') 1
# ndhp xdhp
spgraph(done)

***variance decomposition
declare vector[string] noms
compute noms = ||'supply','demand'||
grparm(noportrait)
spgraph(vfields=3,hfields=2,window='Variance Decomposition')
graph(max=1.0,number=1,style=stacked,header=country+': variance decomposition (growth rates)',subhead='dy',klabel=noms) 2
# v31 1 nstep 1
# v32 1 nstep 2
graph(max=1.0,number=1,samesize,style=stacked,subhead='dn',klabel=noms) 2
# v21 1 nstep 1
# v22 1 nstep 2
graph(max=1.0,number=1,key=below,samesize,style=stacked,subhead='dx',klabel=noms) 2
# v11 1 nstep 1
# v12 1 nstep 2
graph(max=1.0,number=1,samesize,style=stacked,header=country+': variance decomposition (levels)',subhead='y',klabel=noms) 2
# var31 1 nstep 1
# var32 1 nstep 2
graph(max=1.0,number=1,samesize,style=stacked,subhead='n',klabel=noms) 2
# var21 1 nstep 1
# var22 1 nstep 2
graph(key=below,max=1.0,number=1,samesize,style=stacked,subhead='x',klabel=noms) 2
# var11 1 nstep 1
# var12 1 nstep 2
spgraph(done)


***impulse responses

spgraph(vfields=3,hfields=2)
graph(header=country+': technology shock',number=0,patterns,style=overlap,subhead='productivity') 3
# c11s 1 irh 1
# xse1 1 irh 3
# xse2 1 irh 3
graph(number=0,patterns,style=overlap,$
      subhead='gdp') 3
# c31s 1 irh 1
# yse1 1 irh 3
# yse2 1 irh 3
graph(number=0,patterns,style=overlap,subhead=labor) 3
# c21s 1 irh 1
# nse1 1 irh 3
# nse2 1 irh 3
graph(header=country+': demand shock',number=0,patterns,style=overlap,subhead='productivity') 3
# c12s 1 irh 1
# xse1 1 irh 3
# xse2 1 irh 3
graph(number=0,style=overlap,patterns,subhead='gdp') 3
# c32s 1 irh 1
# yse1 1 irh 3
# yse2 1 irh 3
graph(number=0,patterns,style=overlap,subhead=labor) 3
# c22s 1 irh 1
# nse1 1 irh 3
# nse2 1 irh 3
spgraph(done)


****GRAPHS OF IMPULSE RESPONSES WITH STANDARD ERROR BANDS

compute [string] irhead = 'Figure  : Estimated Impulse Responses'
compute [string] irsub = country + ' , ' + labor + ',' + trans
grparm(noportrait)
*spgraph(vfields=3,hfields=2,header = irhead,subhead= irsub)
spgraph(vfields=3,hfields=2)
graph(header='Technology Shock',number=0,patterns,style=symbols,hlabel='productivity') 3
# c11s 1 irh 1
# c11sa 1 irh 3
# c11sb 1 irh 3
graph(number=0,patterns,style=symbols,hlabel='gdp') 3
# c31s 1 irh 1
# c31sa 1 irh 3
# c31sb 1 irh 3
graph(number=0,patterns,style=symbols,hlabel=labor) 3
# c21s 1 irh  1
# c21sa 1 irh 3
# c21sb 1 irh 3
graph(header='Non-Technology Shock',number=0,patterns,style=symbols,hlabel='productivity') 3
# c12s 1 irh 1
# c12sa 1 irh 3
# c12sb 1 irh 3
graph(number=0,style=symbols,patterns,hlabel='gdp') 3
# c32s 1 irh 1
# c32sa 1 irh 3
# c32sb 1 irh 3
graph(number=0,patterns,style=symbols,hlabel=labor) 3
# c22s 1 irh  1
# c22sa 1 irh 3
# c22sb 1 irh 3
spgraph(done)



**********************************************************************************************************
**********************************************************************************************************
**********S T A N D A R D    E R R O R S    (D E L T A   M E T H O D)*************************************
**********************************************************************************************************
**********************************************************************************************************


compute dimthe = (lags+1)*nvar**2
compute dimalf = lags*nvar**2
compute dimra = nvar*(nvar+1)/2
compute dimrb = nvar*(nvar-1)/2
compute dimphi = dimalf+dimra

declare rectangular AVAR(dimalf+dimra,dimalf+dimra)
declare rectangular AMATS(nvar,nvar) GAMMAT(nvar*lags,nvar*lags)
declare rectangular MMAT(nvar*irh,nvar*irh) PMM(nvar**2,nvar**2)
declare rectangular BMAT(nvar,nvar*irh) BMINV(nvar,nvar*irh)
declare rectangular DTHEA(dimalf,dimthe) DTHER(nvar**2,dimthe)
declare rectangular DALFAS(nvar**2,dimalf) ESEMATS(nvar,nvar)
declare rectangular DALFM((nvar*irh)**2,dimalf) DTHEM((nvar*irh)**2,dimthe)
declare rectangular UTMAT(irh,irh) ONE(lags,1)
declare rectangular QMAT(dimrb,nvar**2) DPHIF(dimthe,dimphi)
declare rectangular D12MAT(nvar**2,dimra) D21MAT(dimrb,dimalf)
declare rectangular DMAT(nvar**2+dimrb,dimalf+dimra)
declare rectangular NMAT(nvar**2+dimrb,nvar**2)

declare rectangular DUPMAT(nvar**2,dimra)

declare rectangular[series] AMAT(nvar,nvar) ACF(nvar,nvar)
declare rectangular[series] IRBAR(nvar+1,nvar) IR(nvar+1,nvar)
declare rectangular[series] IRSE(nvar+1,nvar) IRBARSE(nvar+1,nvar)
declare rectangular[series] IRBARH(nvar+1,nvar) IRBARL(nvar+1,nvar)


smpl fp+1 lp

statistics(noprint) dx
set dxhat = dx - %mean

statistics(noprint) dnz
set dnzhat = dnz - %mean

system(model=varmodel)
variables dxhat dnzhat
lags 1 to lags
end(system)

estimate(outsigma=SIGMAT,noprint,noftests)
compute betamat=%modelgetcoeffs(varmodel)
compute NOBS = %nobs


compute DUPMAT = %const(0.0)
do H = 1,nvar
   do J = 1,nvar-(H-1)
      compute DUPMAT((H-1)*(nvar+1)+J,(H-1)*nvar-((H-1)*(H-2)/2)+J) = 1.0
   end do J
end do H



***asymptotic covariance for reduced form coefficients
***ref: Lutkepohl (1990)***

compute XPRIMEX = inv(%xx)

do I =1,nvar
   do J =1,nvar
      clear ACF(I,J)
      do K = 1,lags
         compute ACF(I,J)(K) = (1.0/NOBS)*XPRIMEX((I-1)*lags+1,(J-1)*lags+K)
      end do K
   end do J
end do I


compute GAMMAT = %const(0.0)
do IB = 1,lags
   do JB = IB,lags
      do I = 1,nvar
         do J = 1,nvar
            compute GAMMAT((IB-1)*nvar+I,(JB-1)*nvar+J) = ACF(I,J)(JB+1-IB)
            compute GAMMAT((JB-1)*nvar+I,(IB-1)*nvar+J) = ACF(J,I)(JB+1-IB)
         end do J
      end do I
end do IB
end do JB


compute AVARALF = %kroneker(inv(GAMMAT),SIGMAT)

compute DPLUS = inv(tr(DUPMAT)*DUPMAT)*tr(DUPMAT)

compute AVARSIG = 2.0*DPLUS*%kroneker(SIGMAT,SIGMAT)*tr(DPLUS)


compute AVAR = %const(0.0)
do I = 1,dimalf
   do J = 1,dimalf
      compute AVAR(I,J) = AVARALF(I,J)
   end do J
end do I

do I = 1,dimra
   do J = 1,dimra
      compute AVAR(dimalf+I,dimalf+J) = AVARSIG(I,J)
   end do J
end do I

**************************
***asymptotic covariance for structural impulse responses
***(Mittnik-Zadrozny EMA,1993)

compute AMATS = %identity(nvar)

do I = 1,nvar
   do J = 1,nvar
      clear AMAT(I,J)
      do K = 1,lags
         compute AMAT(I,J)(K) = BETAMAT((J-1)*lags+K,I)
         compute AMATS(I,J) = AMATS(I,J) - AMAT(I,J)(K)
      end do K
   end do J
end do I

ewise DTHEA(I,J) = I==J
ewise DTHER(I,J) = I+dimalf==J


compute MMAT = %identity(nvar*irh)
do IB = 1,irh-1
   do JB = IB+1,%IMIN(IB+lags,irh)
      do I = 1,nvar
         do J = 1,nvar
            compute K = JB-IB
            compute MMAT((IB-1)*nvar+I,(JB-1)*nvar+J) = -1.0*AMAT(J,I)(K)
         end do J
      end do I
   end do JB
end do IB

compute MINV = inv(MMAT)

do I = 1,nvar
   do J = 1,nvar*irh
      compute BMINV(I,J) = MINV(I,J)
   end do J
end do I



****long-run recursive restrictions

compute EMATS = inv(AMATS)
compute CMATS = %decomp(%MQFORM(SIGMAT,tr(EMATS)))
compute RMAT = AMATS*CMATS

compute QMAT = %const(0.0)
compute U = 0
do I = 1, nvar-1
   do J = I+1,nvar
      compute U = U + 1
      compute QMAT(U,(J-1)*nvar+I) = 1.0
   end do J
end do I


****impulse responses

compute CMAT = tr(RMAT)*BMINV

ewise UTMAT(I,J) = J>=I
compute KMAT = %kroneker(UTMAT,%identity(nvar))

compute CBARMAT = CMAT*KMAT

*****


compute DALFM = %const(0.0)
compute DTHEM = %const(0.0)
do K = 1,lags
   do I = 1,nvar
      do J = 1,nvar
         compute alfpos = (K-1)*nvar**2 + (J-1)*nvar + I
         do U = 1,irh-K
            compute vecmpos = (K-1+U)*irh*nvar**2 + (I-1)*nvar*irh + (U-1)*nvar + J
            compute DALFM(vecmpos,alfpos) = -1.0
            compute DTHEM(vecmpos,alfpos) = -1.0
         end do U
      end do J
   end do I
end do K

do I=1,nvar**2
   compute DTHER(I,dimalf+I) = 1.0
end do I

compute PMM = %const(0.0)
do I = 1,nvar
   do J = 1,nvar
      compute PMM((I-1)*nvar+J,(J-1)*nvar+I) = 1.0
   end do J
end do I


compute DTHEC1 = tr( %kroneker(BMINV,%IDENTITY(nvar)))*PMM*DTHER
compute DTHEC2 = -1.0*tr( %kroneker(MINV,tr(CMAT)) )*DTHEM
compute DTHEC = DTHEC1 + DTHEC2

compute DTHECB = %kroneker(tr(KMAT),%identity(nvar))*DTHEC

compute ONE = %const(1.0)
compute JMAT = %kroneker(ONE,%IDENTITY(nvar))

compute DTHEAS = -1.0*%kroneker(tr(JMAT),%identity(nvar))*DTHEA

ewise DALFAS(I,J) = DTHEAS(I,J)

compute DTHECS1 = -1.0*%kroneker(tr(CMATS),EMATS)*DTHEAS
compute DTHECS2 = %kroneker(%IDENTITY(nvar),EMATS)*DTHER
compute DTHECS = DTHECS1+DTHECS2


************

compute N1MAT = (%identity(nvar**2)+PMM)*%kroneker(RMAT,%identity(nvar))
compute N2MAT = QMAT*%kroneker(%identity(nvar),EMATS)

do I = 1,nvar**2
   do J = 1,nvar**2
      compute NMAT(I,J) = N1MAT(I,J)
   end do J
end do I

do I = 1,dimrb
   do J = 1,nvar**2
      compute NMAT(I+nvar**2,J) = N2MAT(I,J)
   end do J
end do I

*************

compute D12MAT = DUPMAT
compute D21MAT = -1.0*QMAT*%kroneker(tr(CMATS),EMATS)*DALFAS


compute DMAT = %const(0.0)

do I = 1,nvar**2
   do J = 1,dimra
      compute DMAT(I,dimalf+J) = D12MAT(I,J)
   end do J
end do I

do I = 1,dimrb
   do J = 1,dimalf
      compute DMAT(nvar**2+I,J) = D21MAT(I,J)
   end do J
end do I

*************

compute DPHIR = inv(tr(NMAT)*NMAT)*tr(NMAT)*DMAT

compute DPHIF = %const(0.0)

do I = 1,dimalf
   compute DPHIF(I,I) = 1.0
end do I

do I = 1,nvar**2
   do J = 1,dimphi
      compute DPHIF(dimalf+I,J) = DPHIR(I,J)
   end do J
end do I

***********

compute OMEGAC = (1.0/NOBS)*DTHEC*DPHIF*AVAR*tr(DPHIF)*tr(DTHEC)
compute OMEGACB = (1.0/NOBS)*DTHECB*DPHIF*AVAR*tr(DPHIF)*tr(DTHECB)

do I = 1,nvar
   do J = 1,nvar
      clear IR(I,J) IRBAR(I,J) IRBARH(I,J) IRBARL(I,J) IRSE(I,J) IRBARSE(I,J)
      do K = 1,irh
         compute IR(I,J)(K) = CMAT(J,(K-1)*nvar+I)
         compute IRBAR(I,J)(K) = CBARMAT(J,(K-1)*nvar+I)
         compute POS = (K-1)*(nvar**2) + (I-1)*nvar + J
         compute IRSE(I,J)(K) = sqrt(OMEGAC(POS,POS))
         compute IRBARSE(I,J)(K) = sqrt(OMEGACB(POS,POS))
         compute IRBARH(I,J)(K) = IRBAR(I,J)(K) + NSE*IRBARSE(I,J)(K)
         compute IRBARL(I,J)(K) = IRBAR(I,J)(K) - NSE*IRBARSE(I,J)(K)
      end do K
   end do J
end do I


******impulse responses for output

do J = 1,nvar
   clear IR(3,J) IRBAR(3,J) IRBARH(3,J) IRBARL(3,J) IRSE(3,J) IRBARSE(3,J)
   do K = 1,irh
      compute IR(3,J)(K) = IR(1,J)(K) + IR(2,J)(K)
      compute IRBAR(3,J)(K) = IRBAR(1,J)(K) + IRBAR(2,J)(K)
      compute POS1 = (K-1)*(nvar**2) + J
      compute POS2 = (K-1)*(nvar**2) + nvar + J
      compute IRSE(3,J)(K) = sqrt( (IRSE(1,J)(K))**2.0 + (IRSE(2,J)(K))**2.0 + 2.0*OMEGAC(POS1,POS2) )
      compute IRBARSE(3,J)(K) = sqrt( (IRBARSE(1,J)(K))**2.0 + (IRBARSE(2,J)(K))**2.0 + 2.0*OMEGACB(POS1,POS2) )
      compute IRBARH(3,J)(K) = IRBAR(3,J)(K) + NSE*IRBARSE(3,J)(K)
      compute IRBARL(3,J)(K) = IRBAR(3,J)(K) - NSE*IRBARSE(3,J)(K)
   end do K
end do J


******conditional correlations


compute dimc = nvar*irh
declare rectangular S1MAT(dimc,irh) S2MAT(dimc,irh)
declare rectangular PCC(nvar*dimc,nvar*dimc)

compute S1MAT = %const(0.0)
compute S2MAT = %const(0.0)

do J = 1,irh
   compute S1MAT((J-1)*nvar+1,J) = 1.0
   compute S2MAT((J-1)*nvar+2,J) = 1.0
end do J

compute C1MAT = CMAT*S1MAT
compute C2MAT = CMAT*S2MAT

compute C12MAT = C1MAT*tr(C2MAT)
compute C11MAT = C1MAT*tr(C1MAT)
compute C22MAT = C2MAT*tr(C2MAT)

compute SSMAT = S1MAT*tr(S2MAT)

compute PCC = %const(0.0)
do I = 1,nvar
   do J = 1,irh
      compute PCC((I-1)*nvar+J,(J-1)*nvar+I) = 1.0
   end do J
end do I

***next makes use of dtheC12 = QCCMAT*dtheC

compute QCCMAT1 = %kroneker( CMAT*tr(SSMAT), %identity(nvar) )
compute QCCMAT2 = %kroneker( %identity(nvar),CMAT*SSMAT) *PCC
compute QCCMAT = QCCMAT1+QCCMAT2
compute OMEGACC = QCCMAT*OMEGAC*tr(QCCMAT)

**conditional covariances and correlations

compute c12z = C12MAT(1,1)
compute r12z = C12MAT(1,1)/sqrt(C11MAT(1,1)*C22MAT(1,1))
compute c12d = C12MAT(2,2)
compute r12d = C12MAT(2,2)/sqrt(C11MAT(2,2)*C22MAT(2,2))

**approx. standard errors for conditional correlations

compute sdr12z = sqrt(OMEGACC(1,1))/sqrt(C11MAT(1,1)*C22MAT(1,1))
compute sdr12d = sqrt(OMEGACC(4,4))/sqrt(C11MAT(2,2)*C22MAT(2,2))


**p-values for null of zero covariance

compute p12z = 2.0*(1.0-%cdf(abs(r12z)/sdr12z))
compute p12d = 2.0*(1.0-%cdf(abs(r12d)/sdr12d))



display '************************************************'
display 'Conditional Employment-Productivity Correlations'
display '************************************************'
display '************************************************'
display 'DELTA METHOD'
display '************************************************'


display 'Growth Rates'
display '*******************'
display 'Technology component:'
display ''
display 'point estimate = ' @50 #.## r12z
display 'standard error = ' @50 #.## sdr12z
display 'p-value  = ' @50 #.#### p12z
display ''
display 'Non-Technology component:'
display ''
display 'point estimate = ' @50 #.### r12d
display 'standard error = ' @50 #.### sdr12d
display 'p-value = ' @50 #.####  p12d
display ''
display ''



****GRAPHS OF IMPULSE RESPONSES WITH STANDARD ERROR BANDS

spgraph(vfields=3,hfields=2,header = 'Figure 2 : '+country)
graph(header='technology shock',number=0,patterns,style=symbols,subhead='productivity') 3
# IRBAR(1,1) 1 irh 1
# IRBARH(1,1) 1 irh 3
# IRBARL(1,1) 1 irh 3
graph(number=0,patterns,style=symbols,subhead='gdp') 3
# IRBAR(3,1) 1 irh 1
# IRBARH(3,1) 1 irh 3
# IRBARL(3,1) 1 irh 3
graph(number=0,patterns,style=symbols,subhead=labor) 3
# IRBAR(2,1) 1 irh 1
# IRBARH(2,1) 1 irh 3
# IRBARL(2,1) 1 irh 3
graph(header='transitory shock',number=0,patterns,style=symbols,subhead='productivity') 3
# IRBAR(1,2) 1 irh 1
# IRBARH(1,2) 1 irh 3
# IRBARL(1,2) 1 irh 3
graph(number=0,style=symbols,patterns,subhead='gdp') 3
# IRBAR(3,2) 1 irh 1
# IRBARH(3,2) 1 irh 3
# IRBARL(3,2) 1 irh 3
graph(number=0,patterns,style=symbols,subhead=labor) 3
# IRBAR(2,2) 1 irh 1
# IRBARH(2,2) 1 irh 3
# IRBARL(2,2) 1 irh 3
spgraph(done)

