*
* Program to replicate the empirical application in Wright (2000), "Alternative
*  Variance-Ratio Tests Using Ranks and Signs", JBES, vol 18, pp 1-9.
*
open data wright.xls
calendar(weekly) 1974 8 7
all 1996:05:29
data(format=xls,org=columns) 1974:08:07 1996:05:29 can deu fra uk jp
*
set can = log(can)
set deu = log(deu)
set fra = log(fra)
set uk  = log(uk)
set jp  = log(jp)
*
source vratio.src
*
* Wright uses a version of the variance ratio which doesn't use finite sample
* corrections in the calculation of the variances. You get this by using
* the NOCORRECT option on VRATIO. For the signs and ranks variations, the
* options NODIFF and NOCENTER are used, since the signs and ranks are computed
* on an already differenced series. NOCENTER assumes the mean is zero, so
* the sample mean isn't subtracted off in the calculations.
*
report(action=define,hlabels=||'k','M1','M2','R1','R2','S1'||)
dofor s = can fra deu jp uk
   set dx = s{0}-s{1}
   report(row=new,atcol=2) %l(s)
   dofor k = 2 5 10 30
      report(row=new,atcol=1) k
      @vratio(lags=k,noprint,nocorrect) s
      report(row=curr,atcol=2) %cdstat
      @vratio(lags=k,noprint,nocorrect,robust) s
      report(row=curr,atcol=3) %cdstat
      order(ranks=rx) dx 2 *
      compute nobs=%nobs
      set r1 = (rx-.5*(nobs+1))/sqrt((nobs**2.0-1)/12)
      @vratio(lags=k,noprint,nocenter,nodiff) r1
      report(row=curr,atcol=4) %cdstat
      set r2 = %invnormal(rx/(nobs+1))
      @vratio(lags=k,noprint,nocenter,nodiff) r2
      report(row=curr,atcol=5) %cdstat
      set s1 = 2*(dx>0.0)-1.0
      @vratio(lags=k,noprint,nocenter,nodiff) s1
      report(row=curr,atcol=6) %cdstat
   end do k
end dofor s
report(action=format,picture='*.##')
report(action=show)


