*
* Tse LM test for constant correlation. Replicates results in Tse, Y. K.(2000), "A
* Test for Constant Correlations in a Multivariate GARCH Model", Journal of
* Econometrics 98, 107-127.
*
* Revision Schedule:
*   07/2005 Rewritten to use GARCH instruction
*
all 812
open data exratew.dat
data(format=free,org=columns) / malaysia singapore
*
compute n=2
*
* This has to follow estimation of a constant correlation model. The GARCH
* instruction below returns the derivatives of the log likelihood with respect to
* the CC model parameters as the vector[series] ccderives. We now need the
* derivatives with respect to the "delta" parameters in the extended model
* rho(i,j)(t)=rho(i,j)+delta(i,j)*e(i)(t)e(j)(t) at delta=0, which will be the CC
* estimates.
*
garch(p=1,q=1,nomean,mv=cc,derives=ccderives,rvector=uv,hmat=h) / malaysia singapore
*
* This drops the first data point since the lagged ee' for that is just the initial
* estimate.
*
compute gstart=%regstart()+1,gend=%regend()
*
* This pulls the subdiagonal of the CC matrix out of the beta vector.
* The "0" in the nslot is equal to the number of mean model parameters
* that are estimated. This will be n if you estimate constant means.
*
dec symm qcinv(n,n)
compute nslot=0+3*n
ewise qcinv(i,j)=%if(i==j,1,%beta(nslot=nslot+1))
compute qcinv=inv(qcinv)
dec symm[series] xd(n-1,n-1)
dec symm uux
dec vect ux
*
dec vector ihu
do time=gstart+1,gend
   compute ux=uv(time),uux=%outerxx(uv(time-1)),hx=h(time),$
        ihu=%diag(%sqrt(%xdiag(hx)))*inv(hx)*ux
   do i=1,n-1
      do j=1,i
         set xd(i,j) time time = -qcinv(i+1,j)*uux(i+1,j)+$
             uux(i+1,j)*ihu(i+1)*ihu(j)
      end do j
   end do i
end do time
dec vector ihu
*
* The t-stat on the xd is the LM statistic
*
set ones gstart gend = 1.0
linreg ones gstart+1 gend
# ccderives xd

