cal 1975 1 4
all 2003:4

open data emudataset.rat
data(format=rats) 1980:1 2003:4 m3nom gdpreal price shortrate longrate ownrate
close data
open data condvar.rat
data(format=rats,compact=geometric) 1975:1 2003:4 cvar
close data
open data condvar.rat
data(format=rats,compact=average) 1975:1 2003:4 r indx
close data

log cvar / lcvar
set lvola2 / = (lcvar{7} + lcvar{6} + lcvar{5} + lcvar{4} + lcvar{3} + lcvar{2} + lcvar{1} + lcvar)/8
diff lvola2 / dlvola2
set lstoxx / = log(indx)
set ret / = (lstoxx - lstoxx{12})/3

set longrate / = longrate/100.0
set shortrate / = shortrate/100.0
set ownrate / = ownrate/100.0
set shortown / = shortrate - ownrate
set longown / = longrate - ownrate
set retown / = ret - ownrate
set longshort / = longrate - shortrate
set mp / = m3nom - price
diff m3nom / dm3nom
diff shortrate / dshort
diff longrate / dlong
diff ownrate / down
diff shortown / dshortown
diff longshort / dlongshort
diff longown / dlongown
diff mp / dmp
diff gdpreal / dgdp
diff price / dprice
diff dprice / ddprice
set dum81q2 / = (t==1981:2)
set dum86 / = 0.5*(t==1986:1)+0.5*(t==1986:3)+0.5*(t==1986:4)+1.0*(t==1986:2)
set fivepc / = 0.05

*** Prozeduren ***
source(noecho) cointendpoint.src
source(noecho) fm_ols.src

*** Parameter ***
comp maxmm = 3, ez = 2003:2
comp ezvec = ||2001:3,2003:2,2003:2||, mmvec = ||11,18,7||


*********************************************************
*** Baseline Specification: gdp, shortown             ***
*********************************************************

disp ' '
disp '          *** Baseline Specification ***'
disp ' '

smpl
@fm_ols(trending=2,report,kernel=2,ltrim=0.2,rtrim=0.2) 1981:1 1998:4 mp
# gdpreal shortown
smpl
@fm_ols(trending=2,report,kernel=2,ltrim=0.2,rtrim=0.2) 1981:1 2003:2 mp
# gdpreal shortown

set baseoverhang / = mp - %FMOLS(1) - %FMOLS(2)*gdpreal - %FMOLS(3)*shortown

do i = 1,maxmm
  comp mm = mmvec(1,i), ez = ezvec(1,i)
  smpl
  @cointendpoint(alpha=0.05,report,regtype=fmols,trending=2) mp 1981:1 ez mm
  # gdpreal shortown
  smpl
  @cointendpoint(alpha=0.05,report,regtype=fiml,trending=2,flag=2,ftrend=2) mp 1980:3 ez mm
  # gdpreal shortown
end do i

****************************************************************
*** Stock Market Specification: gdp, shortown, retown, lvola ***
****************************************************************

disp ' '
disp '          *** Stock Market Specification ***'
disp ' '

smpl
@fm_ols(trending=2,report,kernel=2,ltrim=0.2,rtrim=0.2) 1981:1 1998:4 mp
# gdpreal shortown  retown lvola2
smpl
@fm_ols(trending=2,report,kernel=2,ltrim=0.2,rtrim=0.2) 1981:1 2003:2 mp
# gdpreal shortown retown lvola2

set stockoverhang / = mp - %FMOLS(1) - %FMOLS(2)*gdpreal - %FMOLS(3)*shortown - %FMOLS(4)*retown - %FMOLS(5)*lvola2

do i = 1,maxmm
  comp mm = mmvec(1,i), ez = ezvec(1,i)
  smpl
  @cointendpoint(alpha=0.05,report,regtype=fmols,trending=2) mp 1981:1 ez mm
  # gdpreal shortown retown lvola2
  smpl
  @cointendpoint(alpha=0.05,report,regtype=fiml,trending=2,flag=2,ftrend=2) mp 1980:3 ez mm
  # gdpreal shortown retown lvola2
end do i


* Make Figure 1
graph 2
# baseoverhang
# stockoverhang

* Make Figure 2
spgraph(vfields=2)
graph 1
# retown
graph 1
# lvola2
spgraph(done)

