*
* Replication file for Diebold, Rudebusch & Aruoba (2006),  "The
* macroeconomy and the yield curve: a dynamic latent factor approach,"
* Journal of Econometrics, vol. 131(1-2), pages 309-338.
*
* There aren't obvious guess values for the larger models with three
* unobservable and three observable factors which work well. As a
* result, we've written this so that it does the smaller models first,
* and uses the estimates from those to seed the larger models.
*
open data "dra data.txt"
calendar(m) 1972
data(format=prn,org=columns) 1972:01 2000:12 m3 m6 m9 m12 m15 m18 m21 m24 m30 $
  m36 m48 m60 m72 m84 m96 m108 m120 cu pi ffr
*
equation yvars *
# m3 to m120
*
compute n=%eqnsize(yvars)
dec vect tau(n)
ewise tau(i)=%value(%mid(%l(i),2,0))
*
* Three factor model
*
compute nf=3
*
dec real lam
dec rect a(nf,nf)
dec symm sw(nf,nf)
dec vect swdiag(nf)
dec vec  mu(nf)
dec rect lambda(nf,n)
dec vect svdiag(n)
dec symm sv
dec vect muy
*
* Function for generating the "C" (loadings) matrix for DLM.
*
function FLoadSetup
type rect FLoadSetup
dim FLoadSetup(3,n)
do i=1,n
   compute tl=tau(i)*lam
   compute FLoadSetup(1,i)=1
   compute FLoadSetup(2,i)=(1-exp(-tl))/tl
   compute FLoadSetup(3,i)=FLoadSetup(2,i)-exp(-tl)
end do i
end FLoadSetup
******
* Guess values
*
compute mu=||7.9,-1.5,-.4||
compute a =.95*%identity(nf)
compute sw=.50*%identity(nf)
compute swdiag=%fill(nf,1,.50)
compute svdiag=%fill(n,1,-5.0)
compute lam=.1
*
* Diagonal Q matrix
*
nonlin a swdiag svdiag mu lam
*
* Calculations fixed across time, but dependent upon parameters
*
function DRASetup3
compute lambda=FLoadSetup()
compute muy=tr(lambda)*mu
compute sv=%diag(%exp(svdiag))
end
******
dlm(startup=%(DRASetup3(),sw=%diag(swdiag)),$
  a=a,sw=sw,sv=sv,c=lambda,y=%eqnxvector(yvars,t)-muy,$
   presample=ergodic,method=bfgs,iters=400)
compute loglDiag=%logl
*
* Full Q matrix
*
compute mu(1)=7.9
nonlin a sw svdiag mu lam
dlm(startup=%(DRASetup3()),$
  a=a,sw=sw,sv=sv,c=lambda,y=%eqnxvector(yvars,t)-muy,$
   presample=ergodic,method=bfgs,iters=400)
*
cdf(title="LR Test for Diagonality") chisqr 2.0*(%logl-loglDiag) 3
test(title="Wald Test for Diagonality",zeros)
# 11 13 14

